/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.guard;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.statemachine.engine.guard.DefaultCisNextGuard;
import com.dtyunxi.cube.statemachine.engine.transaction.CisTransactionManagerUtils;
import com.dtyunxi.cube.statemachine.engine.utils.CisActionContextUtils;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisGuardResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.guard.Guard;

public abstract class AbstractCisGuard<S, E, AC extends CisActionDefine>
implements Guard<S, E> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCisGuard.class);
    protected final String guardMessage;
    protected final String guardFalseCode;
    protected final AC actionDefine;
    protected final boolean needThrough;

    public AbstractCisGuard(AC actionDefine, String guardMessage, boolean needThrough) {
        this.guardMessage = guardMessage;
        this.actionDefine = actionDefine;
        this.needThrough = needThrough;
        this.guardFalseCode = "-3000";
    }

    public AbstractCisGuard(AC actionDefine, String guardFalseCode, String guardMessage, boolean needThrough) {
        this.guardMessage = guardMessage;
        this.actionDefine = actionDefine;
        this.needThrough = needThrough;
        this.guardFalseCode = guardFalseCode;
    }

    public final boolean evaluate(StateContext<S, E> context) {
        logger.info("StatemachineLogTrack cisStatemachineGuard execute begin" + this.guardMessage);
        boolean result = this.executeGuard(context);
        logger.info("StatemachineLogTrack cisStatemachineGuard execute " + this.guardMessage + "\uff0cresult=" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeGuard(StateContext<S, E> context) {
        CisBaseOrderMessageHeaders cisBaseOrderMessageHeaders = (CisBaseOrderMessageHeaders)CisActionContextUtils.getMessageHeaderVoByContext(context, CisBaseOrderMessageHeaders.class);
        if (cisBaseOrderMessageHeaders == null) {
            logger.info("StatemachineLogTrack statemachine auto guard return false:" + this.guardMessage);
            return false;
        }
        Throwable throwable = null;
        CisGuardResult cisGuardResult = null;
        try {
            cisGuardResult = this.evaluateSub(context);
            boolean bl = cisGuardResult.isGuardResult();
            return bl;
        }
        catch (Throwable e) {
            logger.error("StatemachineLogTrack cisStatemachineGuard error " + this.guardMessage + " : " + e.getMessage(), e);
            throwable = e;
            CisTransactionManagerUtils.actionTransactionRollback(false);
        }
        finally {
            if (cisGuardResult == null) {
                cisGuardResult = new CisGuardResult(false);
            }
            if (!cisGuardResult.isGuardResult() && this.needThrough || throwable != null) {
                CisGuardResult guardResult = new CisGuardResult((Guard)this, false);
                guardResult.setGuardResultCode(this.guardFalseCode);
                guardResult.setGuardThrowable(throwable);
                if (throwable instanceof BizException) {
                    guardResult.setGuardFalseMessage(throwable.getMessage());
                } else if (StringUtils.isNotBlank((CharSequence)cisGuardResult.getGuardFalseMessage())) {
                    guardResult.setGuardFalseMessage(cisGuardResult.getGuardFalseMessage());
                } else {
                    guardResult.setGuardFalseMessage("'" + this.guardMessage + "'\u89c4\u5219\u4e0d\u901a\u8fc7");
                }
                cisBaseOrderMessageHeaders.addGuardResult(String.valueOf(cisBaseOrderMessageHeaders.getThroughDto().getId()), this.actionDefine, guardResult, throwable);
                cisBaseOrderMessageHeaders.addGuardResult2ExeResult(String.valueOf(cisBaseOrderMessageHeaders.getThroughDto().getId()), this.actionDefine, guardResult, throwable);
            } else {
                CisGuardResult exeResult = new CisGuardResult((Guard)this, cisGuardResult);
                if (StringUtils.isBlank((CharSequence)exeResult.getGuardFalseMessage())) {
                    exeResult.setGuardFalseMessage(this.guardMessage);
                }
                cisBaseOrderMessageHeaders.addGuardResult2ExeResult(String.valueOf(cisBaseOrderMessageHeaders.getThroughDto().getId()), this.actionDefine, exeResult, null);
            }
        }
        return false;
    }

    public abstract CisGuardResult evaluateSub(StateContext<S, E> var1);

    public final DefaultCisNextGuard<S, E, AC> next(AbstractCisGuard<S, E, AC> abstractCisGuard) {
        return new DefaultCisNextGuard<S, E, AC>(this, abstractCisGuard);
    }

    public String getGuardMessage() {
        return this.guardMessage;
    }

    public AC getActionDefine() {
        return this.actionDefine;
    }

    public boolean isNeedThrough() {
        return this.needThrough;
    }
}

