/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.guard;

import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.guard.AbstractCisGuard;
import com.dtyunxi.cube.statemachine.engine.utils.CisActionContextUtils;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseRequest;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisActionResult;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisGuardResult;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;

public abstract class AbstractCisGuardByActionGuard<AC extends CisActionDefine, S, E, DTO extends ThroughDtoDefine, RQ>
extends AbstractCisGuard<S, E, AC> {
    private static Logger logger = LoggerFactory.getLogger(AbstractCisGuardByActionGuard.class);

    public AbstractCisGuardByActionGuard(AC actionDefine, String guardMessage, boolean needThrough) {
        super(actionDefine, guardMessage, needThrough);
    }

    public AbstractCisGuardByActionGuard(AC actionDefine, String guardFailCode, String guardMessage, boolean needThrough) {
        super(actionDefine, guardFailCode, guardMessage, needThrough);
    }

    @Override
    public CisGuardResult evaluateSub(StateContext<S, E> context) {
        CisBaseOrderMessageHeaders cisBaseOrderMessageHeaders = (CisBaseOrderMessageHeaders)CisActionContextUtils.getMessageHeaderVoByContext(context, CisBaseOrderMessageHeaders.class);
        ThroughDtoDefine throughDto = cisBaseOrderMessageHeaders.getThroughDto();
        return this.actionGuard(throughDto, this.exchangeRequestException(cisBaseOrderMessageHeaders));
    }

    public RQ exchangeRequestException(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders) {
        try {
            return this.exchangeRequest(cisBaseOrderMessageHeaders);
        }
        catch (Exception e) {
            logger.error(this.getGuardMessage() + "-guard request\u672a\u8f6c\u6362\u6210\u529f\uff1a" + e.getMessage());
            throw e;
        }
    }

    public RQ exchangeRequest(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders) {
        return (RQ)Optional.ofNullable(cisBaseOrderMessageHeaders.getLastActionResultSub()).map(rs -> this.exchangeRequest(cisBaseOrderMessageHeaders, (CisActionResult<AC, ?>)rs)).orElseGet(() -> this.exchangeRequest(cisBaseOrderMessageHeaders, null));
    }

    public RQ exchangeRequestDefault(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders, CisActionResult<AC, ?> lastCisActionResult) {
        return this.exchangeRequest(cisBaseOrderMessageHeaders, lastCisActionResult);
    }

    public RQ exchangeRequest(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders, CisActionResult<AC, ?> lastCisActionResult) {
        return this.defaultExchange(cisBaseOrderMessageHeaders, lastCisActionResult);
    }

    protected RQ defaultExchange(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders, CisActionResult<AC, ?> lastCisActionResult) {
        try {
            return (RQ)((CisBaseRequest)cisBaseOrderMessageHeaders.getRequest()).getRequestData();
        }
        catch (Exception e) {
            logger.error("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{this.getGuardMessage() + "\u672a\u914d\u7f6erequest\u8f6c\u6362\u5230" + lastCisActionResult.getAction()});
        }
    }

    public abstract CisGuardResult actionGuard(DTO var1, RQ var2);
}

