/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.interceptor;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.transaction.CisTransactionManagerUtils;
import com.dtyunxi.cube.statemachine.engine.utils.CisActionContextUtils;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.result.DgStatemachineStateResult;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.persist.AbstractPersistingStateMachineInterceptor;
import org.springframework.statemachine.persist.DefaultStateMachinePersister;
import org.springframework.statemachine.persist.StateMachinePersister;
import org.springframework.statemachine.persist.StateMachineRuntimePersister;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.DefaultStateMachineContext;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.transition.Transition;

public abstract class AbstractDgStatemachineInterceptor<S, E, T extends CisBaseOrderMessageHeaders<?, S, E, ?, THR>, THR extends ThroughDtoDefine>
extends AbstractPersistingStateMachineInterceptor<S, E, T>
implements StateMachineRuntimePersister<S, E, T>,
StateMachinePersister<S, E, T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDgStatemachineInterceptor.class);
    private DefaultStateMachinePersister<S, E, T> defaultStateMachinePersister = new DefaultStateMachinePersister((StateMachinePersist)this);

    public StateMachineInterceptor<S, E> getInterceptor() {
        logger.debug("StatemachineLogTrack JPA---getInterceptor");
        return this;
    }

    public void write(StateMachineContext<S, E> context, T contextObj) throws Exception {
        logger.debug("StatemachineLogTrack JPA---write");
        this.saveState((Long)contextObj.getBizHeaderByClass("EVENT_MESSAGE_HEADER_VO_THOUGH_ID", Long.class), Optional.ofNullable(contextObj.getThroughDto()).map(ThroughDtoDefine::getStateDefine).orElse(null), context.getState(), contextObj.getEvent(), contextObj);
    }

    public StateMachineContext<S, E> read(T contextObj) throws Exception {
        logger.debug("StatemachineLogTrack JPA---read");
        Long throughId = (Long)contextObj.getBizHeaderByClass("EVENT_MESSAGE_HEADER_VO_THOUGH_ID", Long.class);
        DgStatemachineStateResult<S, E, THR> dgStatemachineStateResult = this.queryStateByThroughId(throughId, contextObj);
        CubeBeanUtils.copyProperties((Object)contextObj.getThroughDto(), (Object)dgStatemachineStateResult.getThroughDto(), (String[])new String[0]);
        return new DefaultStateMachineContext(dgStatemachineStateResult.getState(), null, null, null, null, String.valueOf(throughId));
    }

    public Message<E> preEvent(Message<E> message, StateMachine<S, E> stateMachine) {
        logger.debug("StatemachineLogTrack JPA-interceptor---preEvent-" + message.getPayload());
        return message;
    }

    public final void preStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
        logger.info("StatemachineLogTrack JPA-interceptor---preStateChange---" + state);
        Throwable throwable = null;
        try {
            CisActionContextUtils.checkGuardError((CisBaseOrderMessageHeaders)((CisBaseOrderMessageHeaders)CisActionContextUtils.getMessageHeaderVoByMessageHeaders((MessageHeaders)message.getHeaders(), CisBaseOrderMessageHeaders.class)));
            if (!this.checkNeedSaveState(state, message, transition, stateMachine, rootStateMachine)) {
                logger.info("StatemachineLogTrack JPA-interceptor---preStateChange---not need save:" + state);
                CisTransactionManagerUtils.actionTransactionCommit();
                return;
            }
        }
        catch (Throwable e) {
            throwable = e;
            logger.error(e.getMessage(), e);
            throw CisStatemachineExceptionCode.buildBusinessRuntimeException((Throwable)e);
        }
        finally {
            if (throwable != null) {
                CisTransactionManagerUtils.actionTransactionRollback();
            }
        }
        try {
            this.cisPreStateChange(state, message, transition, stateMachine, rootStateMachine);
            CisTransactionManagerUtils.actionTransactionCommit();
        }
        catch (BizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            CisTransactionManagerUtils.actionTransactionRollback();
            throw e;
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            CisTransactionManagerUtils.actionTransactionRollback();
            throw CisStatemachineExceptionCode.buildBusinessRuntimeException((Throwable)e);
        }
    }

    public void postStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
        logger.debug("StatemachineLogTrack JPA-interceptor---postStateChange---" + state);
    }

    public StateContext<S, E> preTransition(StateContext<S, E> stateContext) {
        logger.debug("StatemachineLogTrack JPA-interceptor---preTransition");
        return stateContext;
    }

    public void cisPreStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) throws Exception {
        StateMachineContext stateMachineContext = this.buildStateMachineContext(stateMachine, rootStateMachine, state, message);
        this.write((StateMachineContext<S, E>)stateMachineContext, (T)((CisBaseOrderMessageHeaders)CisActionContextUtils.getMessageHeaderVoByMessageHeaders((MessageHeaders)message.getHeaders())));
    }

    public boolean checkNeedSaveState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) throws Exception {
        Object st = null;
        st = state.isSubmachineState() ? this.getDeepState(state) : state.getId();
        return this.checkNeedSaveState(st);
    }

    private S getDeepState(State<S, E> state) {
        Collection ids1 = state.getIds();
        Object[] ids2 = ids1.toArray();
        return (S)ids2[ids2.length - 1];
    }

    public StateContext<S, E> postTransition(StateContext<S, E> stateContext) {
        logger.debug("StatemachineLogTrack JPA-interceptor---postTransition");
        return stateContext;
    }

    public Exception stateMachineError(StateMachine<S, E> stateMachine, Exception exception) {
        logger.debug("StatemachineLogTrack JPA-interceptor---stateMachineError");
        return exception;
    }

    public void persist(StateMachine<S, E> stateMachine, T contextObj) throws Exception {
        this.defaultStateMachinePersister.persist(stateMachine, contextObj);
    }

    public StateMachine<S, E> restore(StateMachine<S, E> stateMachine, T contextObj) throws Exception {
        return this.defaultStateMachinePersister.restore(stateMachine, contextObj);
    }

    public abstract void saveState(Long var1, String var2, S var3, E var4, T var5);

    public abstract DgStatemachineStateResult<S, E, THR> queryStateByThroughId(Long var1, T var2);

    public abstract boolean checkNeedSaveState(S var1) throws Exception;
}

