/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.listener;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.statemachine.engine.enums.EventExecuteListenerType;
import com.dtyunxi.cube.statemachine.engine.enums.EventExecuteVoExchangeFields;
import com.dtyunxi.cube.statemachine.engine.enums.EventRecordExecuteStatusEnum;
import com.dtyunxi.cube.statemachine.engine.handler.StatemachineEventExecuteRecordHandler;
import com.dtyunxi.cube.statemachine.engine.listener.AbstractStatemachineEventExecuteListener;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseRequest;
import com.dtyunxi.cube.statemachine.engine.vo.listener.EventExecuteListenerVo;
import com.dtyunxi.cube.statemachine.engine.vo.listener.StatemachineEventExecuteRecordVo;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisRegisterEvent;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractDefaultStatemachineEventExecuteListener<S, E, THR extends ThroughDtoDefine>
extends AbstractStatemachineEventExecuteListener<S, E, THR>
implements StatemachineEventExecuteRecordHandler {
    private final Logger logger = LoggerFactory.getLogger(AbstractDefaultStatemachineEventExecuteListener.class);
    @Value(value="${dg.statemachine.listener.async.execute.flag:true}")
    private Boolean asyncExecuteFlag;

    public abstract String exchangeField(EventExecuteVoExchangeFields var1, EventExecuteListenerVo<S, E, THR> var2, Object var3);

    @Override
    public void afterEventRegister(EventExecuteListenerVo<S, E, THR> eventExecuteListenerVo) {
        if (this.asyncExecuteFlag.booleanValue()) {
            Map objs = ServiceContext.getContext().getAttachments();
            super.afterEventRegister(eventExecuteListenerVo);
        }
    }

    @Override
    public void preEventExecute(EventExecuteListenerVo<S, E, THR> eventExecuteListenerVo) {
        super.preEventExecute(eventExecuteListenerVo);
    }

    @Override
    public void endEventExecute(EventExecuteListenerVo<S, E, THR> eventExecuteListenerVo) {
        super.endEventExecute(eventExecuteListenerVo);
    }

    @Override
    public boolean checkEventExeRecordIdExist(Long eventRecordId, EventExecuteListenerType eventExecuteListenerType) {
        try {
            return this.queryRecordById(eventRecordId) != null;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public Long saveEventExeRecord(EventExecuteListenerVo<S, E, THR> eventExecuteListenerVo, EventExecuteListenerType eventExecuteListenerType) {
        Long eventRecordId = null;
        try {
            switch (eventExecuteListenerType) {
                case AFTER_REGISTER: {
                    StatemachineEventExecuteRecordVo afterEventRecordDto = StatemachineEventExecuteRecordVo.builder().build();
                    afterEventRecordDto.setThroughId(eventExecuteListenerVo.getCisRegisterEvent().getThoughDtoId());
                    afterEventRecordDto.setThroughType(this.exchangeField(EventExecuteVoExchangeFields.THOUGH_TYPE, eventExecuteListenerVo, null));
                    afterEventRecordDto.setBizModel(eventExecuteListenerVo.getBizModel());
                    afterEventRecordDto.setEvent(this.exchangeField(EventExecuteVoExchangeFields.EVENT_CODE, eventExecuteListenerVo, eventExecuteListenerVo.getCisRegisterEvent().getRegisterEvent()));
                    afterEventRecordDto.setEventDesc(this.exchangeField(EventExecuteVoExchangeFields.EVENT_DESC, eventExecuteListenerVo, eventExecuteListenerVo.getCisRegisterEvent().getRegisterEvent()));
                    afterEventRecordDto.setExecuteStatus(EventRecordExecuteStatusEnum.REGISTER.getCode());
                    afterEventRecordDto.setFormEventRecordId(eventExecuteListenerVo.getCisRegisterEvent().getFormEventRecordId());
                    afterEventRecordDto.setExtension(ServiceContext.getContext().getRequestId());
                    eventRecordId = this.addRecord(afterEventRecordDto);
                    break;
                }
                case PRE_EXECUTE: {
                    StatemachineEventExecuteRecordVo preEventRecordDto = StatemachineEventExecuteRecordVo.builder().build();
                    preEventRecordDto.setThroughId(eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getThroughDto().getId());
                    preEventRecordDto.setThroughType(this.exchangeField(EventExecuteVoExchangeFields.THOUGH_TYPE, eventExecuteListenerVo, null));
                    preEventRecordDto.setBizModel(eventExecuteListenerVo.getBizModel());
                    preEventRecordDto.setEvent(this.exchangeField(EventExecuteVoExchangeFields.EVENT_CODE, eventExecuteListenerVo, eventExecuteListenerVo.getEvent()));
                    preEventRecordDto.setEventDesc(this.exchangeField(EventExecuteVoExchangeFields.EVENT_DESC, eventExecuteListenerVo, eventExecuteListenerVo.getEvent()));
                    if (eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest() != null && ((CisBaseRequest)eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest()).getRequestData() != null) {
                        preEventRecordDto.setExecuteRequestJson(JSON.toJSONString((Object)((CisBaseRequest)eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest()).getRequestData()));
                        preEventRecordDto.setExecuteRequestClassName(((CisBaseRequest)eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest()).getRequestData().getClass().getName());
                    }
                    preEventRecordDto.setExecuteStatus(EventRecordExecuteStatusEnum.PRE_EXE.getCode());
                    preEventRecordDto.setFormEventRecordId(eventExecuteListenerVo.getCisRegisterEvent().getFormEventRecordId());
                    preEventRecordDto.setExtension(ServiceContext.getContext().getRequestId());
                    eventRecordId = this.addRecord(preEventRecordDto);
                    break;
                }
                case END_EXECUTE: {
                    StatemachineEventExecuteRecordVo endEventRecordDto = StatemachineEventExecuteRecordVo.builder().build();
                    endEventRecordDto.setThroughId(eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getThroughDto().getId());
                    endEventRecordDto.setThroughType(this.exchangeField(EventExecuteVoExchangeFields.THOUGH_TYPE, eventExecuteListenerVo, null));
                    endEventRecordDto.setBizModel(eventExecuteListenerVo.getBizModel());
                    endEventRecordDto.setEvent(this.exchangeField(EventExecuteVoExchangeFields.EVENT_CODE, eventExecuteListenerVo, eventExecuteListenerVo.getEvent()));
                    endEventRecordDto.setEventDesc(this.exchangeField(EventExecuteVoExchangeFields.EVENT_DESC, eventExecuteListenerVo, eventExecuteListenerVo.getEvent()));
                    endEventRecordDto.setPreEventState(this.exchangeField(EventExecuteVoExchangeFields.PRE_STATE, eventExecuteListenerVo, eventExecuteListenerVo.getPreState()));
                    endEventRecordDto.setEndEventState(this.exchangeField(EventExecuteVoExchangeFields.END_STATE, eventExecuteListenerVo, eventExecuteListenerVo.getEndState()));
                    endEventRecordDto.setPreEventTime(Optional.ofNullable(eventExecuteListenerVo.getPreTime()).orElseGet(Date::new));
                    endEventRecordDto.setEndEventTime(Optional.ofNullable(eventExecuteListenerVo.getEndTime()).orElseGet(Date::new));
                    endEventRecordDto.setExecuteTime(Long.valueOf(endEventRecordDto.getEndEventTime().getTime() - endEventRecordDto.getPreEventTime().getTime()));
                    endEventRecordDto.setExecuteStatus(Optional.ofNullable(eventExecuteListenerVo.getThrowable()).map(throwable -> EventRecordExecuteStatusEnum.EXE_ERROR.getCode()).orElse(EventRecordExecuteStatusEnum.EXE_SUCCESS.getCode()));
                    endEventRecordDto.setFormEventRecordId(eventExecuteListenerVo.getCisRegisterEvent().getFormEventRecordId());
                    endEventRecordDto.setExtension(ServiceContext.getContext().getRequestId());
                    endEventRecordDto.setExecuteErrorMessage((String)Optional.ofNullable(eventExecuteListenerVo.getThrowable()).map(Throwable::getMessage).orElse(null));
                    endEventRecordDto.setExecuteErrorCode((String)Optional.ofNullable(eventExecuteListenerVo.getThrowable()).map(throwable -> {
                        if (throwable instanceof BusinessRuntimeException) {
                            return ((BusinessRuntimeException)throwable).getCode();
                        }
                        return null;
                    }).orElse(null));
                    if (eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest() != null && ((CisBaseRequest)eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest()).getRequestData() != null) {
                        endEventRecordDto.setExecuteRequestJson(JSON.toJSONString((Object)((CisBaseRequest)eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest()).getRequestData()));
                        endEventRecordDto.setExecuteRequestClassName(((CisBaseRequest)eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest()).getRequestData().getClass().getName());
                    }
                    endEventRecordDto.setExtension(ServiceContext.getContext().getRequestId());
                    eventRecordId = this.addRecord(endEventRecordDto);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return eventRecordId;
    }

    @Override
    public int modifyEventExeRecord(Long eventRecordId, EventExecuteListenerVo<S, E, THR> eventExecuteListenerVo, EventExecuteListenerType eventExecuteListenerType) {
        int modifyCount = 0;
        try {
            switch (eventExecuteListenerType) {
                case AFTER_REGISTER: 
                case PRE_EXECUTE: {
                    break;
                }
                case END_EXECUTE: {
                    StatemachineEventExecuteRecordVo statemachineEventExecuteRecordVo = StatemachineEventExecuteRecordVo.builder().build();
                    statemachineEventExecuteRecordVo.setId(eventRecordId);
                    statemachineEventExecuteRecordVo.setBizModel(eventExecuteListenerVo.getBizModel());
                    statemachineEventExecuteRecordVo.setEvent(this.exchangeField(EventExecuteVoExchangeFields.EVENT_CODE, eventExecuteListenerVo, eventExecuteListenerVo.getEvent()));
                    Long thoughDtoId = Optional.ofNullable(eventExecuteListenerVo.getCisRegisterEvent()).map(CisRegisterEvent::getThoughDtoId).orElseGet(() -> eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getThroughDto().getId());
                    statemachineEventExecuteRecordVo.setThroughId(thoughDtoId);
                    statemachineEventExecuteRecordVo.setPreEventState(this.exchangeField(EventExecuteVoExchangeFields.PRE_STATE, eventExecuteListenerVo, eventExecuteListenerVo.getPreState()));
                    statemachineEventExecuteRecordVo.setEndEventState(this.exchangeField(EventExecuteVoExchangeFields.END_STATE, eventExecuteListenerVo, eventExecuteListenerVo.getEndState()));
                    statemachineEventExecuteRecordVo.setPreEventTime(Optional.ofNullable(eventExecuteListenerVo.getPreTime()).orElseGet(Date::new));
                    statemachineEventExecuteRecordVo.setEndEventTime(Optional.ofNullable(eventExecuteListenerVo.getEndTime()).orElseGet(Date::new));
                    statemachineEventExecuteRecordVo.setExecuteTime(Long.valueOf(statemachineEventExecuteRecordVo.getEndEventTime().getTime() - statemachineEventExecuteRecordVo.getPreEventTime().getTime()));
                    statemachineEventExecuteRecordVo.setExecuteStatus(Optional.ofNullable(eventExecuteListenerVo.getThrowable()).map(throwable -> EventRecordExecuteStatusEnum.EXE_ERROR.getCode()).orElse(EventRecordExecuteStatusEnum.EXE_SUCCESS.getCode()));
                    statemachineEventExecuteRecordVo.setExecuteErrorMessage((String)Optional.ofNullable(eventExecuteListenerVo.getThrowable()).map(Throwable::getMessage).orElse(null));
                    statemachineEventExecuteRecordVo.setExecuteErrorCode((String)Optional.ofNullable(eventExecuteListenerVo.getThrowable()).map(throwable -> {
                        if (throwable instanceof BusinessRuntimeException) {
                            return ((BusinessRuntimeException)throwable).getCode();
                        }
                        return null;
                    }).orElse(null));
                    if (eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest() != null && ((CisBaseRequest)eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest()).getRequestData() != null) {
                        statemachineEventExecuteRecordVo.setExecuteRequestJson(JSON.toJSONString((Object)((CisBaseRequest)eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest()).getRequestData()));
                        statemachineEventExecuteRecordVo.setExecuteRequestClassName(((CisBaseRequest)eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getRequest()).getRequestData().getClass().getName());
                    }
                    statemachineEventExecuteRecordVo.getExtFields().put("allExeResult", eventExecuteListenerVo.getCisBaseOrderMessageHeaders().getAllExeResultList());
                    statemachineEventExecuteRecordVo.getExtFields().put("preEventState", statemachineEventExecuteRecordVo.getPreEventState());
                    statemachineEventExecuteRecordVo.getExtFields().put("endEventState", statemachineEventExecuteRecordVo.getEndEventState());
                    statemachineEventExecuteRecordVo.setExtension(ServiceContext.getContext().getRequestId());
                    modifyCount = this.updateRecord(statemachineEventExecuteRecordVo);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return modifyCount;
    }
}

