/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.listener;

import com.dtyunxi.cube.statemachine.engine.enums.EventExecuteListenerType;
import com.dtyunxi.cube.statemachine.engine.listener.StatemachineEventExecuteListener;
import com.dtyunxi.cube.statemachine.engine.utils.CompletableFutureUtils;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.listener.EventExecuteListenerVo;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractStatemachineEventExecuteListener<S, E, THR extends ThroughDtoDefine>
implements StatemachineEventExecuteListener<S, E, THR> {
    @Value(value="${dg.statemachine.listener.async.execute.flag:true}")
    private Boolean asyncExecuteFlag;

    public void afterEventRegister(EventExecuteListenerVo<S, E, THR> eventExecuteListenerVo) {
        Long recordId = this.saveEventExeRecord(eventExecuteListenerVo, EventExecuteListenerType.AFTER_REGISTER);
        if (eventExecuteListenerVo.getCisRegisterEvent() != null) {
            eventExecuteListenerVo.getCisRegisterEvent().setEventExeRecordId(recordId);
        }
    }

    public void preEventExecute(EventExecuteListenerVo<S, E, THR> eventExecuteListenerVo) {
        if (eventExecuteListenerVo.getCisRegisterEvent() == null || eventExecuteListenerVo.getCisRegisterEvent().getEventExeRecordId() == null) {
            Long recordId = this.saveEventExeRecord(eventExecuteListenerVo, EventExecuteListenerType.PRE_EXECUTE);
            if (eventExecuteListenerVo.getCisRegisterEvent() != null) {
                eventExecuteListenerVo.getCisRegisterEvent().setEventExeRecordId(recordId);
            }
        }
    }

    public void endEventExecute(EventExecuteListenerVo<S, E, THR> eventExecuteListenerVo) {
        if (eventExecuteListenerVo.getCisRegisterEvent() != null && eventExecuteListenerVo.getCisRegisterEvent().getEventExeRecordId() != null) {
            if (this.asyncExecuteFlag.booleanValue()) {
                CompletableFutureUtils.runAsync(o -> this.doModifyInEndExeEvent(eventExecuteListenerVo));
            } else {
                this.doModifyInEndExeEvent(eventExecuteListenerVo);
            }
        } else {
            this.saveEventExeRecord(eventExecuteListenerVo, EventExecuteListenerType.END_EXECUTE);
        }
    }

    private void doModifyInEndExeEvent(EventExecuteListenerVo<S, E, THR> eventExecuteListenerVo) {
        int upResult = this.modifyEventExeRecord(eventExecuteListenerVo.getCisRegisterEvent().getEventExeRecordId(), eventExecuteListenerVo, EventExecuteListenerType.END_EXECUTE);
        if (upResult <= 0 && !this.checkEventExeRecordIdExist(eventExecuteListenerVo.getCisRegisterEvent().getEventExeRecordId(), EventExecuteListenerType.END_EXECUTE)) {
            this.saveEventExeRecord(eventExecuteListenerVo, EventExecuteListenerType.END_EXECUTE);
        }
    }

    public abstract boolean checkEventExeRecordIdExist(Long var1, EventExecuteListenerType var2);

    public abstract Long saveEventExeRecord(EventExecuteListenerVo<S, E, THR> var1, EventExecuteListenerType var2);

    public abstract int modifyEventExeRecord(Long var1, EventExecuteListenerVo<S, E, THR> var2, EventExecuteListenerType var3);
}

