/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.listener;

import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.transaction.CisTransactionManagerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.statemachine.trigger.Trigger;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class DefaultCisStatemachineListener<S, E>
implements StateMachineListener<S, E> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCisStatemachineListener.class);
    @Resource
    private DataSourceTransactionManager dataSourceTransactionManager;

    public void stateChanged(State<S, E> from, State<S, E> to) {
        logger.debug("StatemachineLogTrack Listener---State change from " + Optional.ofNullable(from).map(State::getId).map(String::valueOf).orElseGet(() -> "-") + " to " + to.getId());
    }

    public void stateEntered(State<S, E> state) {
        logger.debug("StatemachineLogTrack Listener---stateEntered-state\uff1a" + state);
    }

    public void stateExited(State<S, E> state) {
        logger.debug("StatemachineLogTrack Listener---stateExited-state\uff1a" + state);
    }

    public void eventNotAccepted(Message<E> event) {
        logger.debug("StatemachineLogTrack Listener---eventNotAccepted-Message.event\uff1a" + event.getPayload() + "\uff0cisSynchronizationActive()=" + TransactionSynchronizationManager.isSynchronizationActive());
    }

    public void transition(Transition<S, E> transition) {
        logger.debug("StatemachineLogTrack Listener---transition-isSynchronizationActive=" + TransactionSynchronizationManager.isSynchronizationActive());
        logger.info("StatemachineLogTrack Listener---transition-Transition\uff1a" + Arrays.toString(Optional.ofNullable(transition.getActions()).orElseGet(() -> new ArrayList()).stream().map(act -> act.getClass().getName()).toArray()) + "\uff0csource state:" + transition.getSource() + "\uff0ctarget state:" + transition.getTarget() + "\uff0c event:" + Optional.ofNullable(transition.getTrigger()).map(Trigger::getEvent));
        try {
            if (Objects.equals(TransitionKind.INTERNAL, transition.getKind())) {
                CisTransactionManagerUtils.actionTransactionCommit();
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            CisTransactionManagerUtils.actionTransactionRollback();
            throw CisStatemachineExceptionCode.buildBusinessRuntimeException((Throwable)e);
        }
    }

    public void transitionStarted(Transition<S, E> transition) {
        logger.debug("StatemachineLogTrack Listener---transitionStarted.isSynchronizationActive()=" + TransactionSynchronizationManager.isSynchronizationActive());
        logger.debug("StatemachineLogTrack Listener---transitionStarted-Transition\uff1a" + Arrays.toString(Optional.ofNullable(transition.getActions()).orElseGet(() -> new ArrayList()).stream().map(act -> act.getClass().getName()).toArray()) + "\uff0csource state:" + transition.getSource() + "\uff0ctarget state:" + transition.getTarget() + "\uff0c event:" + Optional.ofNullable(transition.getTrigger()).map(Trigger::getEvent));
    }

    public void transitionEnded(Transition<S, E> transition) {
        logger.debug("StatemachineLogTrack Listener---transitionStarted-Transition\uff1a" + Arrays.toString(Optional.ofNullable(transition.getActions()).orElseGet(() -> new ArrayList()).stream().map(act -> act.getClass().getName()).toArray()) + "\uff0csource state:" + transition.getSource() + "\uff0ctarget state:" + transition.getTarget() + "\uff0c event:" + Optional.ofNullable(transition.getTrigger()).map(Trigger::getEvent));
    }

    public void stateMachineStarted(StateMachine<S, E> stateMachine) {
        logger.debug("StatemachineLogTrack Listener---stateMachineStarted-StateMachine\uff1a" + stateMachine.getId());
    }

    public void stateMachineStopped(StateMachine<S, E> stateMachine) {
        logger.debug("StatemachineLogTrack Listener---stateMachineStopped-StateMachine\uff1a" + stateMachine.getId());
    }

    public void stateMachineError(StateMachine<S, E> stateMachine, Exception exception) {
        logger.debug("StatemachineLogTrack Listener---stateMachineError-StateMachine" + stateMachine.getId() + "\uff0cexception=" + exception.getClass());
    }

    public void extendedStateChanged(Object key, Object value) {
        logger.debug("StatemachineLogTrack Listener---extendedStateChanged-key\uff1a" + key + "\uff0cvalue\uff1a" + value);
    }

    public void stateContext(StateContext<S, E> stateContext) {
        logger.debug("StatemachineLogTrack Listener---stateContext-StateContext>>>exchange");
    }
}

