/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.listener;

import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.transaction.CisTransactionManagerUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionKind;

public class SimpleStateMachineListener<S, E>
implements StateMachineListener<S, E> {
    private static final Logger log = LoggerFactory.getLogger(SimpleStateMachineListener.class);

    public void stateChanged(State<S, E> from, State<S, E> to) {
    }

    public void stateEntered(State<S, E> state) {
    }

    public void stateExited(State<S, E> state) {
    }

    public void eventNotAccepted(Message<E> event) {
    }

    public void transition(Transition<S, E> transition) {
        try {
            if (Objects.equals(TransitionKind.INTERNAL, transition.getKind())) {
                CisTransactionManagerUtils.actionTransactionCommit();
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            CisTransactionManagerUtils.actionTransactionRollback();
            throw CisStatemachineExceptionCode.buildBusinessRuntimeException((Throwable)e);
        }
    }

    public void transitionStarted(Transition<S, E> transition) {
    }

    public void transitionEnded(Transition<S, E> transition) {
    }

    public void stateMachineStarted(StateMachine<S, E> stateMachine) {
    }

    public void stateMachineStopped(StateMachine<S, E> stateMachine) {
    }

    public void stateMachineError(StateMachine<S, E> stateMachine, Exception exception) {
    }

    public void extendedStateChanged(Object key, Object value) {
    }

    public void stateContext(StateContext<S, E> stateContext) {
    }
}

