/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.transaction;

import com.dtyunxi.util.SpringBeanUtil;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class CisTransactionManagerUtils {
    private static final Logger logger = LoggerFactory.getLogger(CisTransactionManagerUtils.class);
    public static final ThreadLocal<TransactionStatus> TRANSACTION_STATUS_THREAD_LOCAL_RUNNING = new NamedThreadLocal("CisTransactionStatusRunning");
    private static DataSourceTransactionManager dataSourceTransactionManager;

    public static void actionTransactionBefore() {
        logger.info("StatemachineLogTrack transaction-\u5f00\u542f\u4e8b\u52a1");
        if (TRANSACTION_STATUS_THREAD_LOCAL_RUNNING.get() != null) {
            logger.info("StatemachineLogTrack transaction-\u6cbf\u7528\u4e8b\u52a1");
            return;
        }
        DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
        defaultTransactionDefinition.setPropagationBehavior(3);
        defaultTransactionDefinition.setIsolationLevel(Optional.ofNullable(TransactionSynchronizationManager.getCurrentTransactionIsolationLevel()).orElseGet(() -> -1).intValue());
        TransactionStatus transactionStatus = CisTransactionManagerUtils.initAndGetDataSourceTransactionManager().getTransaction((TransactionDefinition)defaultTransactionDefinition);
        TRANSACTION_STATUS_THREAD_LOCAL_RUNNING.set(transactionStatus);
    }

    private static DataSourceTransactionManager initAndGetDataSourceTransactionManager() {
        if (dataSourceTransactionManager == null) {
            dataSourceTransactionManager = (DataSourceTransactionManager)SpringBeanUtil.getBean(DataSourceTransactionManager.class);
        }
        return dataSourceTransactionManager;
    }

    public static void actionTransactionCommit() {
        CisTransactionManagerUtils.actionTransactionCommit(false);
    }

    public static void actionTransactionCommit(boolean hadTransaction) {
        TransactionStatus transactionStatus = TRANSACTION_STATUS_THREAD_LOCAL_RUNNING.get();
        if (!hadTransaction && Objects.isNull(transactionStatus)) {
            return;
        }
        if (Objects.isNull(transactionStatus)) {
            logger.error("StatemachineLogTrack transactionError transaction-\u9700\u63d0\u4ea4\u4e8b\u52a1\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6d41\u7a0b", (Throwable)new RuntimeException("\u9700\u63d0\u4ea4\u4e8b\u52a1\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6d41\u7a0b"));
            return;
        }
        logger.info("StatemachineLogTrack transaction-\u63d0\u4ea4");
        try {
            if (transactionStatus.isRollbackOnly()) {
                logger.error("StatemachineLogTrack transactionError transaction-\u63d0\u4ea4-\u53ea\u56de\u6eda", (Throwable)new RuntimeException("\u5f53\u524d\u4e8b\u52a1\u53ea\u5141\u8bb8\u56de\u6eda\uff0c\u539f\u56e0\u53ef\u80fd\uff1a\u5b50\u4e8b\u52a1\u5f02\u5e38\u88ab\u6355\u83b7\uff0c\u8bf7\u68c0\u67e5\u8c03\u7528\u94fe\u8def"));
                CisTransactionManagerUtils.initAndGetDataSourceTransactionManager().rollback(transactionStatus);
            } else if (transactionStatus.isCompleted()) {
                logger.info("StatemachineLogTrack transaction-\u63d0\u4ea4-\u4e8b\u52a1\u5df2\u5b8c\u6210-\u65e0\u9700\u518d\u63d0\u4ea4");
            } else {
                CisTransactionManagerUtils.initAndGetDataSourceTransactionManager().commit(transactionStatus);
            }
        }
        catch (Exception e) {
            if (transactionStatus.isCompleted()) {
                TRANSACTION_STATUS_THREAD_LOCAL_RUNNING.remove();
            }
            throw e;
        }
        TRANSACTION_STATUS_THREAD_LOCAL_RUNNING.remove();
    }

    public static void actionTransactionRollback() {
        CisTransactionManagerUtils.actionTransactionRollback(false);
    }

    public static void actionTransactionRollback(boolean hadTransaction) {
        TransactionStatus transactionStatus = TRANSACTION_STATUS_THREAD_LOCAL_RUNNING.get();
        if (!hadTransaction && Objects.isNull(transactionStatus)) {
            return;
        }
        if (Objects.isNull(transactionStatus)) {
            logger.error("StatemachineLogTrack transactionError transaction-\u9700\u63d0\u4ea4\u4e8b\u52a1\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6d41\u7a0b", (Throwable)new RuntimeException("\u9700\u63d0\u4ea4\u4e8b\u52a1\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6d41\u7a0b"));
            return;
        }
        logger.info("StatemachineLogTrack transaction-\u56de\u6eda\u4e8b\u52a1");
        try {
            if (!transactionStatus.isCompleted()) {
                CisTransactionManagerUtils.initAndGetDataSourceTransactionManager().rollback(transactionStatus);
            } else {
                logger.info("StatemachineLogTrack transaction-\u4e8b\u52a1\u5df2\u5b8c\u6210-\u65e0\u6cd5\u56de\u6eda");
            }
        }
        catch (Exception e) {
            if (transactionStatus.isCompleted()) {
                TRANSACTION_STATUS_THREAD_LOCAL_RUNNING.remove();
            }
            throw e;
        }
        TRANSACTION_STATUS_THREAD_LOCAL_RUNNING.remove();
    }

    public static boolean checkHadTransaction() {
        return TRANSACTION_STATUS_THREAD_LOCAL_RUNNING.get() != null;
    }
}

