/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.interceptor;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.CheckTokenReqDto;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class UserSsoLoginInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(UserSsoLoginInterceptor.class);
    private String respResult = "{\"resultCode\":401,\"resultMsg\":\"no login\"}";
    public final ITokenApi tokenApi;

    public UserSsoLoginInterceptor(ITokenApi tokenApi) {
        this.tokenApi = tokenApi;
    }

    public boolean preHandle(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Object handler) throws Exception {
        boolean isContinue = false;
        CheckTokenReqDto checkTokenReqDto = this.genCheckTokenReqDto(httpRequest);
        if (this.checkToken(checkTokenReqDto)) {
            isContinue = true;
        } else {
            this.notLoginResponse(httpResponse);
        }
        return isContinue;
    }

    private CheckTokenReqDto genCheckTokenReqDto(HttpServletRequest httpRequest) {
        CheckTokenReqDto checkTokenReqDto = new CheckTokenReqDto();
        String token = httpRequest.getParameter("token");
        String tenantIdStr = httpRequest.getParameter("tenantId");
        String instanceIdStr = httpRequest.getParameter("instanceId");
        checkTokenReqDto.setToken(token);
        checkTokenReqDto.setTenantId(Long.valueOf(tenantIdStr));
        checkTokenReqDto.setInstanceId(Long.valueOf(instanceIdStr));
        return checkTokenReqDto;
    }

    private boolean checkToken(CheckTokenReqDto checkTokenReqDto) {
        try {
            RestResponse<Map<String, Object>> restResponse = this.tokenApi.checkToken(checkTokenReqDto);
            if ("0".equals(restResponse.getResultCode())) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8ctoken\u51fa\u9519 : {} \u3002\u8be5\u9519\u8bef\u88ab\u5ffd\u7565", (Object)e.getMessage());
        }
        return false;
    }

    private void notLoginResponse(HttpServletResponse httpResponse) throws IOException {
        httpResponse.setStatus(401);
        PrintWriter out = httpResponse.getWriter();
        out.append(this.respResult);
        out.close();
    }
}

