/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class BigDecimalUtils {
    public static final BigDecimal ONE_HUNDRED = BigDecimalUtils.parse("100");

    public static BigDecimal add(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        b = BigDecimalUtils.check(b);
        return a.add(b);
    }

    public static BigDecimal subtract(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        b = BigDecimalUtils.check(b);
        return a.subtract(b);
    }

    public static BigDecimal multiply(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        b = BigDecimalUtils.check(b);
        return a.multiply(b);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        if (BigDecimalUtils.eqZero(b = BigDecimalUtils.check(b)).booleanValue()) {
            return BigDecimal.ZERO;
        }
        return a.divide(b, 0, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b, int scale) {
        a = BigDecimalUtils.check(a);
        if (BigDecimalUtils.eqZero(b = BigDecimalUtils.check(b)).booleanValue()) {
            return BigDecimal.ZERO;
        }
        return a.divide(b, scale, RoundingMode.HALF_UP);
    }

    public static Boolean equals(BigDecimal a, BigDecimal b) {
        return (a = BigDecimalUtils.check(a)).compareTo(b = BigDecimalUtils.check(b)) == 0;
    }

    public static Boolean notEquals(BigDecimal a, BigDecimal b) {
        return BigDecimalUtils.equals(a = BigDecimalUtils.check(a), b = BigDecimalUtils.check(b)) == false;
    }

    public static Boolean gt(BigDecimal a, BigDecimal b) {
        return (a = BigDecimalUtils.check(a)).compareTo(b = BigDecimalUtils.check(b)) > 0;
    }

    public static Boolean leZero(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.le(a, BigDecimal.ZERO);
    }

    public static Boolean ltZero(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.lt(a, BigDecimal.ZERO);
    }

    public static Boolean eqZero(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.equals(a, BigDecimal.ZERO);
    }

    public static Boolean geZero(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.ge(a, BigDecimal.ZERO);
    }

    public static Boolean gtZero(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.gt(a, BigDecimal.ZERO);
    }

    public static Boolean lt(BigDecimal a, BigDecimal b) {
        return (a = BigDecimalUtils.check(a)).compareTo(b = BigDecimalUtils.check(b)) < 0;
    }

    public static Boolean ge(BigDecimal a, BigDecimal b) {
        return BigDecimalUtils.equals(a, b) != false || BigDecimalUtils.gt(a, b) != false;
    }

    public static Boolean le(BigDecimal a, BigDecimal b) {
        return BigDecimalUtils.equals(a, b) != false || BigDecimalUtils.lt(a, b) != false;
    }

    public static BigDecimal check(BigDecimal a) {
        return null == a ? BigDecimal.ZERO : a;
    }

    public static BigDecimal abs(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return a.abs();
    }

    public static BigDecimal negate(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.multiply(a, BigDecimalUtils.parse("-1"));
    }

    public static BigDecimal parse(String a) {
        if (StringUtils.isBlank((CharSequence)a)) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(a);
    }
}

