/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressResolutionUtil {
    private static final Logger log = LoggerFactory.getLogger(AddressResolutionUtil.class);

    public static AddressDto addressResolution(String address) {
        try {
            return AddressResolutionUtil.executeResolution(address);
        }
        catch (Exception e) {
            log.error("\u8be6\u7ec6\u5730\u5740\u89e3\u6790\u5931\u8d25: {}, {}", (Object)address, (Object)e.getMessage());
            return null;
        }
    }

    private static AddressDto executeResolution(String address) {
        String regex = "(?<province>[^\u7701]+\u81ea\u6cbb\u533a|\u4e03\u53f0\u6cb3|\u4e07\u5b81|\u4e07\u6e90|\u4e09\u4e9a|\u4e09\u660e|\u4e09\u6c99|\u4e09\u6cb3|\u4e09\u95e8\u5ce1|\u4e0a\u6d77|\u4e0a\u9976|\u4e1c\u5174|\u4e1c\u53f0|\u4e1c\u5b81|\u4e1c\u65b9|\u4e1c\u6e2f|\u4e1c\u82b1|\u4e1c\u839e|\u4e1c\u8425|\u4e1c\u9633|\u4e2a\u65e7|\u4e2d\u536b|\u4e2d\u5c71|\u4e30\u57ce|\u4e30\u9547|\u4e34\u590f|\u4e34\u6c5f|\u4e34\u6c7e|\u4e34\u6c82|\u4e34\u6ca7|\u4e34\u6d77|\u4e34\u6e05|\u4e34\u6e58|\u4e39\u4e1c|\u4e39\u6c5f\u53e3|\u4e39\u9633|\u4e3d\u6c34|\u4e3d\u6c5f|\u4e49\u4e4c|\u4e49\u9a6c|\u4e4c\u5170\u5bdf\u5e03|\u4e4c\u5170\u6d69\u7279|\u4e4c\u6d77|\u4e4c\u82cf|\u4e4c\u9c81\u6728\u9f50|\u4e50\u5c71|\u4e50\u5e73|\u4e50\u660c|\u4e50\u6e05|\u4e50\u9675|\u4e5d\u6c5f|\u4e73\u5c71|\u4e8c\u8fde\u6d69\u7279|\u4e91\u6d6e|\u4e94\u5927\u8fde\u6c60|\u4e94\u5bb6\u6e20|\u4e94\u5e38|\u4e94\u6307\u5c71|\u4e95\u5188\u5c71|\u4eac\u5c71|\u4eb3\u5dde|\u4ec0\u90a1|\u4ec1\u6000|\u4ecb\u4f11|\u4ed9\u6843|\u4eea\u5f81|\u4efb\u4e18|\u4f0a\u5b81|\u4f0a\u6625|\u4f59\u59da|\u4f5b\u5c71|\u4f73\u6728\u65af|\u4faf\u9a6c|\u4fdd\u5b9a|\u4fdd\u5c71|\u4fe1\u5b9c|\u4fe1\u9633|\u5019\u53e3\u8857\u9053\u5929\u95e8|\u5043\u5e08|\u510b\u5dde|\u514b\u62c9\u739b\u4f9d|\u5168|\u516c\u4e3b\u5cad|\u516d\u5b89|\u516d\u76d8\u6c34|\u5170\u5dde|\u5170\u6eaa|\u5171\u9752\u57ce|\u5174\u4e49|\u5174\u5316|\u5174\u57ce|\u5174\u5b81|\u5174\u5e73|\u5185\u6c5f|\u51b7\u6c34\u6c5f|\u51cc\u6d77|\u51cc\u6e90|\u51e4\u57ce|\u51ed\u7965|\u51ef\u91cc|\u5229\u5ddd|\u5305\u5934|\u5316\u5dde|\u5317\u4eac|\u5317\u5b81|\u5317\u5b89|\u5317\u5c6f|\u5317\u6d41|\u5317\u6d77|\u5317\u7968|\u5317\u9547|\u5341\u5830|\u534e\u84e5|\u534e\u9634|\u5357\u4eac|\u5357\u5145|\u5357\u533a\u4e07\u79d1\u57ce|\u5357\u5b81|\u5357\u5b89|\u5357\u5bab|\u5357\u5e73|\u5357\u6295|\u5357\u660c|\u5357\u901a|\u5357\u9633|\u5357\u96c4|\u535a\u4e50|\u536b\u8f89|\u539f\u5e73|\u53a6\u95e8|\u53cc\u6cb3|\u53cc\u8fbd|\u53cc\u9e2d\u5c71|\u53e4\u4ea4|\u53e5\u5bb9|\u53ef\u514b\u8fbe\u62c9|\u53f0\u4e1c|\u53f0\u4e2d|\u53f0\u5317|\u53f0\u5357|\u53f0\u5c71|\u53f0\u5dde|\u5408\u4f5c|\u5408\u5c71|\u5408\u80a5|\u5409\u5b89|\u5409\u6797|\u5409\u9996|\u540c\u6c5f|\u5410\u9c81\u756a|\u5415\u6881|\u542f\u4e1c|\u5434\u5ddd|\u5434\u5fe0|\u5458\u6797|\u5468\u53e3|\u547c\u4f26\u8d1d\u5c14|\u547c\u548c\u6d69\u7279|\u548c\u7530|\u548c\u9f99|\u54b8\u5b81|\u54b8\u9633|\u54c8\u5bc6|\u54c8\u5c14\u6ee8|\u5510\u5c71|\u5546\u4e18|\u5546\u6d1b|\u5580\u4ec0|\u5609\u4e49|\u5609\u5174|\u5609\u5cea\u5173|\u56db\u4f1a|\u56db\u5e73|\u56ed\u6797\u8857\u9053\u6e56\u5317\u7701\u6f5c\u6c5f|\u56ed\u6797\u8857\u9053\u6f5c\u6c5f|\u56fa\u539f|\u56fe\u4eec|\u56fe\u6728\u8212\u514b|\u57fa\u9686|\u5854\u57ce|\u5927\u51b6|\u5927\u540c|\u5927\u5b89|\u5927\u5e86|\u5927\u6cbb|\u5927\u7406|\u5927\u77f3\u6865|\u5927\u8fde|\u5927\u8fde\u6c60|\u5929\u6c34|\u5929\u6d25|\u5929\u957f|\u5929\u95e8|\u592a\u4ed3|\u592a\u4fdd|\u592a\u539f|\u5934\u4efd|\u594e\u5c6f|\u5982\u768b|\u5a01\u6d77|\u5a04\u5e95|\u5b5d\u4e49|\u5b5d\u611f|\u5b5f\u5dde|\u5b81\u4e61|\u5b81\u56fd|\u5b81\u5b89|\u5b81\u5fb7|\u5b81\u6ce2|\u5b89\u4e18|\u5b89\u56fd|\u5b89\u5b81|\u5b89\u5e86|\u5b89\u5eb7|\u5b89\u8fbe|\u5b89\u9633|\u5b89\u9646|\u5b89\u987a|\u5b9a\u5dde|\u5b9a\u897f|\u5b9c\u5170|\u5b9c\u5174|\u5b9c\u57ce|\u5b9c\u5bbe|\u5b9c\u660c|\u5b9c\u6625|\u5b9c\u90fd|\u5b9d\u9e21|\u5ba3\u57ce|\u5ba3\u5a01|\u5bbf\u5dde|\u5bbf\u8fc1|\u5bc6\u5c71|\u5bcc\u9526|\u5bff\u5149|\u5c1a\u5fd7|\u5c4f\u4e1c|\u5c71\u5357|\u5c91\u6eaa|\u5cb3\u9633|\u5ce8\u7709\u5c71|\u5d07\u5dde|\u5d07\u5de6|\u5d4a\u5dde|\u5de2\u6e56|\u5de9\u4e49|\u5df4\u4e2d|\u5df4\u5f66\u6dd6\u5c14|\u5e38\u5b81|\u5e38\u5dde|\u5e38\u5fb7|\u5e38\u719f|\u5e73\u51c9|\u5e73\u5ea6|\u5e73\u6cc9|\u5e73\u6e56|\u5e73\u9876\u5c71|\u5e7f\u5143|\u5e7f\u5b89|\u5e7f\u5dde|\u5e7f\u6c34|\u5e7f\u6c49|\u5e84\u6cb3|\u5e86\u9633|\u5e90\u5c71|\u5e93\u5c14\u52d2|\u5e94\u57ce|\u5eb7\u5b9a|\u5ec9\u6c5f|\u5eca\u574a|\u5ef6\u5409|\u5ef6\u5b89|\u5efa\u5fb7|\u5efa\u74ef|\u5f00\u539f|\u5f00\u5c01|\u5f00\u5e73|\u5f00\u8fdc|\u5f20\u5bb6\u53e3|\u5f20\u5bb6\u6e2f|\u5f20\u5bb6\u754c|\u5f20\u6396|\u5f25\u52d2|\u5f53\u9633|\u5f6c\u5dde|\u5f6d\u5dde|\u5f70\u5316|\u5f90\u5dde|\u5fb7\u4ee4\u54c8|\u5fb7\u5174|\u5fb7\u5dde|\u5fb7\u60e0|\u5fb7\u9633|\u5ffb\u5dde|\u6000\u4ec1|\u6000\u5316|\u6069\u5e73|\u6069\u65bd|\u60e0\u5dde|\u6148\u6eaa|\u6210\u90fd|\u624e\u5170\u5c6f|\u626c\u4e2d|\u626c\u5dde|\u6276\u4f59|\u627f\u5fb7|\u629a\u5dde|\u629a\u8fdc|\u629a\u987a|\u62c9\u8428|\u62db\u8fdc|\u63ed\u9633|\u6500\u679d\u82b1|\u6566\u5316|\u6566\u714c|\u6587\u5c71|\u6587\u660c|\u6597\u516d|\u65b0\u4e50|\u65b0\u4e61|\u65b0\u4f59|\u65b0\u5317|\u65b0\u5bc6|\u65b0\u6c11|\u65b0\u6c82|\u65b0\u6cf0|\u65b0\u7af9|\u65b0\u90d1|\u65e0\u9521|\u65e5\u5580\u5219|\u65e5\u7167|\u6606\u5c71|\u6606\u660e|\u6606\u7389|\u660c\u5409|\u660c\u9091|\u660c\u90fd|\u660e\u5149|\u662d\u901a|\u664b\u4e2d|\u664b\u57ce|\u664b\u5dde|\u664b\u6c5f|\u666e\u5b81|\u666e\u6d31|\u666f\u5fb7\u9547|\u666f\u6d2a|\u66f2\u961c|\u66f2\u9756|\u6714\u5dde|\u671d\u9633|\u672c\u6eaa|\u6734\u5b50|\u6765\u5bbe|\u676d\u5dde|\u677e\u539f|\u677e\u6ecb|\u6797\u5dde|\u6797\u829d|\u679d\u6c5f|\u67a3\u5e84|\u67a3\u9633|\u67f3\u5dde|\u6816\u971e|\u682a\u6d32|\u6839\u6cb3|\u683c\u5c14\u6728|\u6842\u5e73|\u6842\u6797|\u6843\u56ed|\u6850\u4e61|\u6850\u57ce|\u6866\u7538|\u6885\u5dde|\u6885\u6cb3\u53e3|\u68a7\u5dde|\u695a\u96c4|\u6986\u6797|\u6986\u6811|\u6a1f\u6811|\u6a2a\u5dde|\u6b66\u5188|\u6b66\u5937\u5c71|\u6b66\u5a01|\u6b66\u5b89|\u6b66\u6c49|\u6b66\u7a74|\u6bd5\u8282|\u6c38\u57ce|\u6c38\u5b89|\u6c38\u5dde|\u6c38\u5eb7|\u6c38\u6d4e|\u6c49\u4e2d|\u6c49\u5ddd|\u6c55\u5934|\u6c55\u5c3e|\u6c5d\u5dde|\u6c5f\u5c71|\u6c5f|\u6c5f\u6cb9|\u6c5f\u95e8|\u6c5f\u9634|\u6c60\u5dde|\u6c68\u7f57|\u6c7e\u9633|\u6c81\u9633|\u6c85\u6c5f|\u6c88\u9633|\u6c99\u6cb3|\u6ca7\u5dde|\u6cb3\u6c60|\u6cb3\u6d25|\u6cb3\u6e90|\u6cb3\u95f4|\u6cc9\u5dde|\u6cca\u5934|\u6cf0\u5174|\u6cf0\u5b89|\u6cf0\u5dde|\u6cf8\u5dde|\u6cf8\u6c34|\u6d1b\u9633|\u6d25||\u6d2a\u6c5f|\u6d2a\u6e56|\u6d2e\u5357|\u6d4e\u5357|\u6d4e\u5b81|\u6d4e\u6e90|\u6d4f\u9633|\u6d77\u4e1c|\u6d77\u4f26|\u6d77\u53e3|\u6d77\u57ce|\u6d77\u5b81|\u6d77\u5b89|\u6d77\u6797|\u6d77\u95e8|\u6d77\u9633|\u6d9f\u6e90|\u6dbf\u5dde|\u6dc4\u535a|\u6dee\u5317|\u6dee\u5357|\u6dee\u5b89|\u6df1\u5733|\u6df1\u5dde|\u6e05\u8fdc|\u6e05\u9547|\u6e29\u5cad|\u6e29\u5dde|\u6e2d\u5357|\u6e56\u5dde|\u6e58\u4e61|\u6e58\u6f6d|\u6e5b\u6c5f|\u6ea7\u9633|\u6ec1\u5dde|\u6ed5\u5dde|\u6ee1\u6d32\u91cc|\u6ee6\u5dde|\u6ee8\u5dde|\u6f20\u6cb3|\u6f2f\u6cb3|\u6f33\u5dde|\u6f33\u5e73|\u6f4d\u574a|\u6f5c\u5c71|\u6f5c\u6c5f|\u6f5e\u57ce|\u6f6e\u5dde|\u6fee\u9633|\u706f\u5854|\u7075\u5b9d|\u7075\u6b66|\u70df\u53f0|\u7126\u4f5c|\u7259\u514b\u77f3|\u7261\u4e39\u6c5f|\u7389\u6797|\u7389\u6811|\u7389\u6eaa|\u7389\u73af|\u7389\u95e8|\u73e0\u6d77|\u73f2\u6625|\u743c\u6d77|\u745e\u4e3d|\u745e\u5b89|\u745e\u660c|\u745e\u91d1|\u74e6\u623f\u5e97|\u754c\u9996|\u767b\u5c01|\u767d\u57ce|\u767d\u5c71|\u767d\u94f6|\u767e\u8272|\u76ca\u9633|\u76d0\u57ce|\u76d6\u5dde|\u76d8\u5dde|\u76d8\u9526|\u7709\u5c71|\u77f3\u5634\u5c71|\u77f3\u5bb6\u5e84|\u77f3\u6cb3\u5b50|\u77f3\u72ee|\u77f3\u9996|\u78d0\u77f3|\u795e\u6728|\u798f\u5b89|\u798f\u5dde|\u798f\u6cc9|\u798f\u6e05|\u798f\u9f0e|\u79b9\u57ce|\u79b9\u5dde|\u79e6\u7687\u5c9b|\u7a46\u68f1|\u7af9\u5317|\u7b80\u9633_\u6210\u90fd|\u7b80\u9633|\u7c73\u6cc9|\u7ecd\u5174|\u7ee5\u5316|\u7ee5\u82ac\u6cb3|\u7ef5\u7af9|\u7ef5\u9633|\u7f57\u5b9a|\u8001\u6cb3\u53e3|\u8012\u9633|\u804a\u57ce|\u8087\u4e1c|\u8087\u5e86|\u80a5\u57ce|\u80e1\u6768\u6cb3|\u80f6\u5357|\u80f6\u5dde|\u817e\u51b2|\u81ea\u8d21|\u8212\u5170|\u821e\u94a2|\u821f\u5c71|\u8292|\u829c\u6e56|\u82b1\u83b2|\u82cf\u5dde|\u82d7\u6817|\u82f1\u5fb7|\u8302\u540d|\u832b\u5d16|\u8346\u5dde|\u8346\u95e8|\u8363\u6210|\u8365\u9633|\u8386\u7530|\u83b1\u5dde|\u83b1\u829c|\u83b1\u897f|\u83b1\u9633|\u83cf\u6cfd|\u840d\u4e61|\u8425\u53e3|\u846b\u82a6\u5c9b|\u8499\u81ea|\u84ec\u83b1|\u864e\u6797|\u868c\u57e0|\u86df\u6cb3|\u8861\u6c34|\u8861\u9633|\u8862\u5dde|\u8944\u9633|\u897f\u5b81|\u897f\u5b89|\u897f\u660c|\u8bb7\u6cb3|\u8bb8\u660c|\u8bf8\u57ce|\u8bf8\u66a8|\u8c03\u5175\u5c71|\u8d35\u6e2f|\u8d35\u6eaa|\u8d35\u9633|\u8d3a\u5dde|\u8d44\u5174|\u8d44\u9633|\u8d63\u5dde|\u8d64\u58c1|\u8d64\u5cf0|\u8d64\u6c34|\u8f89\u53bf|\u8f9b\u96c6|\u8fbd\u6e90|\u8fbd\u9633|\u8fbe\u5dde|\u8fc1\u5b89|\u8fd0\u57ce|\u8fde\u4e91\u6e2f|\u8fde\u5dde|\u901a\u5316|\u901a\u5dde|\u901a\u8fbd|\u9042\u5b81|\u9075\u4e49|\u9075\u5316|\u9093\u5dde|\u909b\u5d03|\u90a2\u53f0|\u90a3\u66f2|\u90af\u90f8|\u90b3\u5dde|\u90b5\u6b66|\u90b5\u9633|\u90b9\u57ce|\u90d1\u5dde|\u90f4\u5dde|\u90fd\u5300|\u90fd\u6c5f\u5830|\u9102\u5c14\u591a\u65af|\u9102\u5dde|\u9152\u6cc9|\u91b4\u9675|\u91cd\u5e86|\u91d1\u534e|\u91d1\u660c|\u949f\u7965|\u94a6\u5dde|\u94c1\u529b|\u94c1\u5cad|\u94c1\u95e8\u5173|\u94dc\u4ec1|\u94dc\u5ddd|\u94dc\u9675|\u94f6\u5ddd|\u9521\u6797\u6d69\u7279|\u9526\u5dde|\u9547\u6c5f|\u957f\u6625|\u957f\u6c99|\u957f\u6cbb|\u957f\u845b|\u9606\u4e2d|\u961c\u5eb7|\u961c\u65b0|\u961c\u9633|\u9632\u57ce\u6e2f|\u9633\u6625|\u9633\u6c5f|\u9633\u6cc9|\u963f\u514b\u82cf|\u963f\u52d2\u6cf0|\u963f\u56fe\u4ec0|\u963f\u57ce|\u963f\u5c14\u5c71|\u963f\u62c9\u5c14|\u963f\u62c9\u5c71\u53e3|\u9646\u4e30|\u9647\u5357|\u9686\u660c|\u968f\u5dde|\u96c5\u5b89|\u96c6\u5b89|\u96f7\u5dde|\u970d\u5c14\u679c\u65af|\u970d\u5dde|\u970d\u6797\u90ed\u52d2|\u9738\u5dde|\u9752\u5c9b|\u9752\u5dde|\u9752\u94dc\u5ce1|\u9756\u6c5f|\u9756\u897f|\u978d\u5c71|\u97e9\u57ce|\u97f6\u5173|\u97f6\u5c71|\u9879\u57ce|\u989d\u5c14\u53e4\u7eb3|\u9999\u683c\u91cc\u62c9|\u9a6c\u516c|\u9a6c\u5c14\u5eb7|\u9a6c\u978d\u5c71|\u9a7b\u9a6c\u5e97|\u9ad8\u5b89|\u9ad8\u5bc6|\u9ad8\u5dde|\u9ad8\u5e73|\u9ad8\u7891\u5e97|\u9ad8\u90ae|\u9ad8\u96c4|\u9e21\u897f|\u9e64\u58c1|\u9e64\u5c71|\u9e64\u5c97|\u9e70\u6f6d|\u9ebb\u57ce|\u9ec4\u5188|\u9ec4\u5c71|\u9ec4\u6ce5\u6cb3\u6797\u4e1a\u5c40\u5409\u6797\u7701\u5ef6\u8fb9\u671d\u9c9c\u65cf\u81ea\u6cbb\u5dde\u6566\u5316|\u9ec4\u77f3|\u9ec4\u9a85|\u9ed1\u6cb3|\u9f50|\u9f50\u9f50\u54c8\u5c14|\u9f99\u4e95|\u9f99\u53e3|\u9f99\u5ca9|\u9f99\u6cc9|\u9f99\u6d77|\u9f99\u6e2f|.*?\u7701|.*?\u884c\u653f\u533a|.*?\u5e02)(?<city>[^\u5e02]+\u81ea\u6cbb\u5dde|.*?\u5e02|.*?\u5730\u533a|.*?\u884c\u653f\u5355\u4f4d|.+\u76df|\u5e02\u8f96\u533a|.*?\u53bf)(?<county>[^\u53bf]+\u53bf|[^\u5e02]+\u5e02|[^\u533a]+\u533a|[^\u4e61]+\u4e61|.+\u573a|.+\u65d7|.+\u6d77\u57df|.+\u5c9b)?(?<town>[^\u533a].+\u9547)?(?<village>.*)";
        Matcher m = Pattern.compile(regex).matcher(address);
        String province = null;
        String city = null;
        String county = null;
        String town = null;
        String village = null;
        ArrayList<AddressDto> addressDtoList = new ArrayList<AddressDto>();
        AddressDto row = null;
        while (m.find()) {
            row = new AddressDto();
            province = m.group("province");
            row.setProvince(province == null ? "" : province.trim());
            city = m.group("city");
            row.setCity(city == null ? "" : city.trim());
            county = m.group("county");
            row.setCounty(county == null ? "" : county.trim());
            town = m.group("town");
            row.setTown(town == null ? "" : town.trim());
            village = m.group("village");
            row.setVillage(village == null ? "" : village.trim());
            addressDtoList.add(row);
        }
        return (AddressDto)addressDtoList.get(0);
    }

    public static class AddressDto {
        private String province;
        private String city;
        private String county;
        private String town;
        private String village;

        public String getProvince() {
            return this.province;
        }

        public String getCity() {
            return this.city;
        }

        public String getCounty() {
            return this.county;
        }

        public String getTown() {
            return this.town;
        }

        public String getVillage() {
            return this.village;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public void setCounty(String county) {
            this.county = county;
        }

        public void setTown(String town) {
            this.town = town;
        }

        public void setVillage(String village) {
            this.village = village;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddressDto)) {
                return false;
            }
            AddressDto other = (AddressDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$province = this.getProvince();
            String other$province = other.getProvince();
            if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$county = this.getCounty();
            String other$county = other.getCounty();
            if (this$county == null ? other$county != null : !this$county.equals(other$county)) {
                return false;
            }
            String this$town = this.getTown();
            String other$town = other.getTown();
            if (this$town == null ? other$town != null : !this$town.equals(other$town)) {
                return false;
            }
            String this$village = this.getVillage();
            String other$village = other.getVillage();
            return !(this$village == null ? other$village != null : !this$village.equals(other$village));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AddressDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $province = this.getProvince();
            result = result * 59 + ($province == null ? 43 : $province.hashCode());
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $county = this.getCounty();
            result = result * 59 + ($county == null ? 43 : $county.hashCode());
            String $town = this.getTown();
            result = result * 59 + ($town == null ? 43 : $town.hashCode());
            String $village = this.getVillage();
            result = result * 59 + ($village == null ? 43 : $village.hashCode());
            return result;
        }

        public String toString() {
            return "AddressResolutionUtil.AddressDto(province=" + this.getProvince() + ", city=" + this.getCity() + ", county=" + this.getCounty() + ", town=" + this.getTown() + ", village=" + this.getVillage() + ")";
        }
    }
}

