/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.ExpressAreaQueryReqDto;
import com.dtyunxi.finance.api.dto.request.ExpressCostContractQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.AppointAreaQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordExtReqDto;
import com.dtyunxi.finance.api.dto.response.ExpressCostAreaRespDto;
import com.dtyunxi.finance.api.dto.response.ExpressCostContractRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.query.IExpressCostContractQueryApi;
import com.dtyunxi.finance.api.query.ILogisticQueryApi;
import com.dtyunxi.mj.biz.commons.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ConsignmentOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ConsignmentOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ConsignmentSignDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentDeliveryOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentOrderDeliveryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentOrderDispatcherInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentOrderReturnRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentRelevanceOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IConsignmentOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ConsignmentOrderAddressDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ConsignmentOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ConsignmentOrderDeliveryInfoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderAddressEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderDeliveryInfoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsShipmenetEnterpriseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ConsignmentOrderAddressMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ConsignmentOrderDeliveryInfoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ConsignmentOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsShipmenetEnterpriseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.SyncAreaReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShipmentLogisticsTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpRegionQueryApi;
import com.yunxi.dg.base.center.basicdata.dto.request.PcpRegionReqDto;
import com.yunxi.dg.base.center.basicdata.dto.response.PcpRegionRespDto;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsignmentOrderServiceImpl
implements IConsignmentOrderService {
    private static final Logger log = LoggerFactory.getLogger(ConsignmentOrderServiceImpl.class);
    @Resource
    private ConsignmentOrderDas consignmentOrderDas;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    ConsignmentOrderMapper consignmentOrderMapper;
    @Autowired
    ConsignmentOrderDeliveryInfoMapper consignmentOrderDeliveryInfoMapper;
    @Autowired
    ConsignmentOrderDeliveryInfoDas consignmentOrderDeliveryInfoDas;
    @Autowired
    CsShipmenetEnterpriseMapper shipmenetEnterpriseMapper;
    @Autowired
    IExpressCostContractQueryApi expressCostContractQueryApi;
    @Autowired
    ILogisticQueryApi logisticQueryApi;
    @Autowired
    ConsignmentOrderAddressMapper consignmentOrderAddressMapper;
    @Autowired
    ConsignmentOrderAddressDas consignmentOrderAddressDas;
    @Autowired
    IPcpRegionQueryApi pcpRegionQueryApi;

    @Override
    public Long addConsignmentOrder(ConsignmentOrderReqDto addReqDto) {
        ConsignmentOrderEo consignmentOrderEo = new ConsignmentOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)consignmentOrderEo);
        this.consignmentOrderDas.insert((BaseEo)consignmentOrderEo);
        return consignmentOrderEo.getId();
    }

    @Override
    public void modifyConsignmentOrder(ConsignmentOrderReqDto modifyReqDto) {
        ConsignmentOrderEo consignmentOrderEo = new ConsignmentOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)consignmentOrderEo);
        this.consignmentOrderDas.updateSelective((BaseEo)consignmentOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeConsignmentOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.consignmentOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ConsignmentOrderRespDto queryById(Long id) {
        ConsignmentOrderEo consignmentOrderEo = (ConsignmentOrderEo)this.consignmentOrderDas.selectByPrimaryKey(id);
        ConsignmentOrderRespDto consignmentOrderRespDto = new ConsignmentOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)consignmentOrderEo, (BaseVo)consignmentOrderRespDto);
        return consignmentOrderRespDto;
    }

    @Override
    public PageInfo<ConsignmentOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ConsignmentOrderReqDto consignmentOrderReqDto = (ConsignmentOrderReqDto)JSON.parseObject((String)filter, ConsignmentOrderReqDto.class);
        ConsignmentOrderEo consignmentOrderEo = new ConsignmentOrderEo();
        DtoHelper.dto2Eo((BaseVo)consignmentOrderReqDto, (BaseEo)consignmentOrderEo);
        PageInfo eoPageInfo = this.consignmentOrderDas.selectPage((BaseEo)consignmentOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ConsignmentOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ConsignmentOrderReturnRespDto> queryWaybillListPage(ConsignmentOrderQueryReqDto dto) {
        PageInfo pageInfo = this.consignmentOrderDas.queryWaybillListPage(dto);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List dtoList = pageInfo.getList().stream().map(o -> {
            ConsignmentOrderReturnRespDto vo = new ConsignmentOrderReturnRespDto();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            if (StringUtils.isNotBlank((CharSequence)o.getTransferConsignmentNo())) {
                vo.setIfTransport("\u662f");
            } else {
                vo.setIfTransport("\u5426");
            }
            if (o.getConsignmentType() != null) {
                vo.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
            }
            if (o.getOrderStatus() != null) {
                vo.setOrderStatusName((String)ConsignmentConstant.ORDER_STATUS.valueMap.get(o.getOrderStatus()));
            }
            vo.setBusinessTypeName(Optional.ofNullable(o.getBusinessType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                if (ObjectUtils.isNotEmpty((Object)CsPcpBusinessTypeEnum.getByCode((String)o.getBusinessType()))) {
                    return String.valueOf(Objects.requireNonNull(CsPcpBusinessTypeEnum.getByCode((String)o.getBusinessType())).getDesc());
                }
                return o.getBusinessType();
            }).orElse(""));
            return vo;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sign(ConsignmentSignDto signDto) {
        List consignmentOrderEos = this.consignmentOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderEo.class).eq(ConsignmentOrderEo::getWmsConsignmentNo, (Object)signDto.getWmsConsignmentNo())).eq(ConsignmentOrderEo::getOrderStatus, (Object)1)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty(consignmentOrderEos, "\u8be5\u5355\u53f7[%s]\u5173\u8054\u8fd0\u5355\u4fe1\u606f\uff0c\u5df2\u5168\u90e8\u4e0d\u5904\u7406\u5f85\u7b7e\u6536\u72b6\u6001", signDto.getWmsConsignmentNo());
        List consignmentNoList = consignmentOrderEos.stream().map(ConsignmentOrderEo::getConsignmentNo).distinct().collect(Collectors.toList());
        List consignmentOrderDeliveryInfoEos = this.consignmentOrderDeliveryInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderDeliveryInfoEo.class).in(ConsignmentOrderDeliveryInfoEo::getConsignmentNo, consignmentNoList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        for (ConsignmentOrderEo consignmentOrderEo : consignmentOrderEos) {
            ConsignmentOrderEo updateConsignmentOrderEo = new ConsignmentOrderEo();
            updateConsignmentOrderEo.setId(consignmentOrderEo.getId());
            updateConsignmentOrderEo.setOrderStatus(Integer.valueOf(2));
            this.consignmentOrderDas.updateSelective((BaseEo)updateConsignmentOrderEo);
        }
        for (ConsignmentOrderDeliveryInfoEo consignmentOrderDeliveryInfoEo : consignmentOrderDeliveryInfoEos) {
            ConsignmentOrderDeliveryInfoEo updateConsignmentOrderDeliveryInfoEo = new ConsignmentOrderDeliveryInfoEo();
            updateConsignmentOrderDeliveryInfoEo.setId(consignmentOrderDeliveryInfoEo.getId());
            updateConsignmentOrderDeliveryInfoEo.setActualArriveTime(signDto.getSignTime());
            this.consignmentOrderDeliveryInfoDas.updateSelective((BaseEo)updateConsignmentOrderDeliveryInfoEo);
        }
    }

    @Override
    public ConsignmentOrderRespDto queryByConsignmentNo(String consignmentNo) {
        ConsignmentOrderEo orderEo = (ConsignmentOrderEo)((ExtQueryChainWrapper)this.consignmentOrderDas.filter().eq((Object)"consignment_no", (Object)consignmentNo)).one();
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)orderEo), "\u8fd0\u5355\u53f7\u4e0d\u5b58\u5728");
        ConsignmentOrderRespDto dto = new ConsignmentOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)dto);
        if (orderEo.getConsignmentType() != null) {
            dto.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(orderEo.getConsignmentType()));
        }
        if (StringUtils.isNotBlank((CharSequence)orderEo.getTransferConsignmentNo())) {
            dto.setIfTransport("\u662f");
        } else {
            dto.setIfTransport("\u5426");
        }
        if (StringUtils.isNotBlank((CharSequence)orderEo.getOutResultNo())) {
            InOutResultOrderEo csOutResultOrderEo = (InOutResultOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"document_no", (Object)orderEo.getOutResultNo())).eq((Object)"order_type", (Object)"out")).one();
            dto.setTotalWeight(csOutResultOrderEo.getTotalWeight());
            dto.setTotalVolume(csOutResultOrderEo.getTotalVolume());
            dto.setTotalCartons(csOutResultOrderEo.getTotalCartons());
            dto.setMergeQuantity(csOutResultOrderEo.getMergeQuantity());
            dto.setDoneQuantity(csOutResultOrderEo.getTotalQuantity());
        }
        return dto;
    }

    @Override
    public ConsignmentDeliveryOrderRespDto queryDeliveryConsignmentNo(String consignmentNo) {
        ConsignmentOrderDeliveryInfoEo deliveryInfoEo;
        List list;
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)consignmentNo), "\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ConsignmentDeliveryOrderRespDto respDto = this.consignmentOrderDas.queryDeliveryConsignmentNo(consignmentNo);
        if (StringUtils.isNotBlank((CharSequence)respDto.getTransferConsignmentNo()) && CollectionUtils.isNotEmpty((Collection)(list = ((ExtQueryChainWrapper)this.consignmentOrderDeliveryInfoDas.filter().eq((Object)"consignment_no", (Object)respDto.getTransferConsignmentNo())).list())) && (deliveryInfoEo = (ConsignmentOrderDeliveryInfoEo)list.get(0)).getActualArriveTime() != null) {
            respDto.setActualArriveTime(deliveryInfoEo.getActualArriveTime());
        }
        return respDto;
    }

    @Override
    public ConsignmentOrderDeliveryInfoRespDto queryWaybillDeliveryConsignmentNo(String consignmentNo) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)consignmentNo), "\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return this.consignmentOrderDas.queryWaybillDeliveryConsignmentNo(consignmentNo);
    }

    @Override
    public List<ConsignmentOrderDispatcherInfoRespDto> queryWaybillDispatcherConsignmentNo(String consignmentNo) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)consignmentNo), "\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return this.consignmentOrderDas.queryWaybillDispatcherConsignmentNo(consignmentNo);
    }

    @Override
    public ConsignmentOrderRespDto queryWaybillTransportConsignmentNo(String consignmentNo) {
        ConsignmentOrderEo orderEo = (ConsignmentOrderEo)((ExtQueryChainWrapper)this.consignmentOrderDas.filter().eq((Object)"consignment_no", (Object)consignmentNo)).one();
        if (ObjectUtils.isEmpty((Object)orderEo)) {
            return null;
        }
        ConsignmentOrderRespDto dto = new ConsignmentOrderRespDto();
        if (StringUtils.isNotBlank((CharSequence)orderEo.getTransferConsignmentNo())) {
            ConsignmentOrderEo eo = (ConsignmentOrderEo)((ExtQueryChainWrapper)this.consignmentOrderDas.filter().eq((Object)"consignment_no", (Object)orderEo.getTransferConsignmentNo())).one();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        }
        if (StringUtils.isNotBlank((CharSequence)orderEo.getTransferConsignmentNo())) {
            dto.setIfTransport("\u662f");
        } else {
            dto.setIfTransport("\u5426");
        }
        return dto;
    }

    @Override
    public List<ConsignmentRelevanceOrderRespDto> queryWaybillRelevanceConsignmentNo(String consignmentNo) {
        SimpleDateFormat simpleDateFormat;
        ConsignmentRelevanceOrderRespDto dto;
        ConsignmentOrderDeliveryInfoEo deliveryInfoEo;
        ConsignmentOrderEo eo;
        ArrayList dtoList = Lists.newArrayList();
        List orderEos = ((ExtQueryChainWrapper)this.consignmentOrderDas.filter().eq((Object)"consignment_no", (Object)consignmentNo)).list();
        if (CollectionUtils.isEmpty((Collection)orderEos)) {
            return null;
        }
        ConsignmentOrderEo orderEo = (ConsignmentOrderEo)orderEos.get(0);
        if (StringUtils.isNotBlank((CharSequence)orderEo.getTransferConsignmentNo())) {
            eo = (ConsignmentOrderEo)((ExtQueryChainWrapper)this.consignmentOrderDas.filter().eq((Object)"consignment_no", (Object)orderEo.getTransferConsignmentNo())).one();
            deliveryInfoEo = (ConsignmentOrderDeliveryInfoEo)((ExtQueryChainWrapper)this.consignmentOrderDeliveryInfoDas.filter().eq((Object)"consignment_no", (Object)orderEo.getTransferConsignmentNo())).one();
            dto = new ConsignmentRelevanceOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
            if (dto.getConsignmentType() != null) {
                dto.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(dto.getConsignmentType()));
            }
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (ObjectUtils.isNotEmpty((Object)deliveryInfoEo)) {
                dto.setCarrierName(deliveryInfoEo.getCarrierName());
                dto.setCarrierType(deliveryInfoEo.getCarrierType());
                dto.setPlanArriveDays(deliveryInfoEo.getPlanArriveDays());
                if (deliveryInfoEo.getDeliveryTime() != null) {
                    dto.setDeliveryTime(simpleDateFormat.format(deliveryInfoEo.getDeliveryTime()));
                }
                if (deliveryInfoEo.getPlanArriveTime() != null) {
                    dto.setPlanArriveTime(simpleDateFormat.format(deliveryInfoEo.getPlanArriveTime()));
                }
                if (deliveryInfoEo.getActualArriveTime() != null) {
                    dto.setActualArriveTime(simpleDateFormat.format(deliveryInfoEo.getActualArriveTime()));
                }
            }
            dtoList.add(dto);
        }
        if (ObjectUtils.isNotEmpty((Object)(eo = (ConsignmentOrderEo)((ExtQueryChainWrapper)this.consignmentOrderDas.filter().eq((Object)"transfer_consignment_no", (Object)consignmentNo)).one()))) {
            deliveryInfoEo = (ConsignmentOrderDeliveryInfoEo)((ExtQueryChainWrapper)this.consignmentOrderDeliveryInfoDas.filter().eq((Object)"consignment_no", (Object)eo.getConsignmentNo())).one();
            dto = new ConsignmentRelevanceOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
            if (dto.getConsignmentType() != null) {
                dto.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(dto.getConsignmentType()));
            }
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (ObjectUtils.isNotEmpty((Object)deliveryInfoEo)) {
                dto.setCarrierName(deliveryInfoEo.getCarrierName());
                dto.setCarrierType(deliveryInfoEo.getCarrierType());
                dto.setPlanArriveDays(deliveryInfoEo.getPlanArriveDays());
                if (deliveryInfoEo.getDeliveryTime() != null) {
                    dto.setDeliveryTime(simpleDateFormat.format(deliveryInfoEo.getDeliveryTime()));
                }
                if (deliveryInfoEo.getPlanArriveTime() != null) {
                    dto.setPlanArriveTime(simpleDateFormat.format(deliveryInfoEo.getPlanArriveTime()));
                }
                if (deliveryInfoEo.getActualArriveTime() != null) {
                    dto.setActualArriveTime(simpleDateFormat.format(deliveryInfoEo.getActualArriveTime()));
                }
            }
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    public int calcPlanArriveDays(String carrierCode, String deliveryPhysicsWarehouseCode, String receiveArea, String receiveCity, String receiveProvince, String logisticsType) {
        log.info("calcPlanArriveDays \u5165\u53c2 carrierCode:{}, deliveryPhysicsWarehouseCode:{}, receiveArea:{}, receiveCity:{}, receiveProvince:{}, logisticsType:{}", new Object[]{carrierCode, deliveryPhysicsWarehouseCode, receiveArea, receiveCity, receiveProvince, logisticsType});
        return this.calcPlanArriveDays(null, carrierCode, deliveryPhysicsWarehouseCode, receiveArea, receiveCity, receiveProvince, logisticsType);
    }

    @Override
    public int calcPlanArriveDays(Long shipmentEnterpriseType, String carrierCode, String deliveryPhysicsWarehouseCode, String receiveArea, String receiveCity, String receiveProvince, String logisticsType) {
        log.info("calcPlanArriveDays \u5165\u53c2 carrierCode:{}, deliveryPhysicsWarehouseCode:{}, receiveArea:{}, receiveCity:{}, receiveProvince:{}, logisticsType:{}", new Object[]{carrierCode, deliveryPhysicsWarehouseCode, receiveArea, receiveCity, receiveProvince, logisticsType});
        if (StringUtils.isBlank((CharSequence)receiveProvince) && StringUtils.isBlank((CharSequence)receiveCity) && StringUtils.isBlank((CharSequence)receiveArea)) {
            return -1;
        }
        CsShipmenetEnterpriseEo csShipmenetEnterpriseEo = (CsShipmenetEnterpriseEo)this.shipmenetEnterpriseMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsShipmenetEnterpriseEo.class).eq(CsShipmenetEnterpriseEo::getShipmentEnterpriseCode, (Object)carrierCode)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (null == csShipmenetEnterpriseEo) {
            log.info("\u901a\u8fc7\u7269\u6d41\u5546\u7f16\u7801[{}], \u627e\u4e0d\u5230\u7269\u6d41\u5546\u4fe1\u606f", (Object)carrierCode);
            return -1;
        }
        if (null == shipmentEnterpriseType) {
            shipmentEnterpriseType = csShipmenetEnterpriseEo.getShipmentEnterpriseType();
        }
        log.info("\u7269\u6d41\u5546\u7c7b\u578b:{}", (Object)shipmentEnterpriseType);
        if (Objects.equals(shipmentEnterpriseType, 2L)) {
            ExpressCostContractQueryReqDto reqDto = new ExpressCostContractQueryReqDto();
            reqDto.setLogisticCode(csShipmenetEnterpriseEo.getShipmentEnterpriseCode());
            reqDto.setWarehouseCode(deliveryPhysicsWarehouseCode);
            CsShipmentLogisticsTypeEnum logisticsTypeEnum = CsShipmentLogisticsTypeEnum.getEnumByName((String)csShipmenetEnterpriseEo.getLogisticsType());
            if (Objects.nonNull(logisticsTypeEnum)) {
                reqDto.setTransportType(logisticsTypeEnum.getType() + "");
            }
            reqDto.setStatus(Integer.valueOf(1));
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(10));
            log.info("\u67e5\u8be2\u751f\u6548\u4e2d\u7684\u5feb\u9012\u8d39\u7528\u8bbe\u7f6e\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)reqDto));
            PageInfo expressCostContractRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.expressCostContractQueryApi.queryByPage(reqDto));
            if (CollectionUtils.isEmpty((Collection)expressCostContractRespDtoPageInfo.getList())) {
                return -1;
            }
            ExpressCostContractRespDto expressCostContractRespDto = (ExpressCostContractRespDto)expressCostContractRespDtoPageInfo.getList().get(0);
            log.info("\u5e02\u533a\u57df\u4fe1\u606f:{},{}", (Object)receiveCity, (Object)receiveArea);
            ExpressAreaQueryReqDto queryReqDto = new ExpressAreaQueryReqDto();
            queryReqDto.setCity(receiveCity);
            queryReqDto.setContractId(expressCostContractRespDto.getId());
            List<Object> list = Lists.newArrayList();
            log.info("\u67e5\u8be2\u5feb\u9012\u8d39\u7528\u533a\u57df\u8bbe\u7f6e\u5165\u53c2:{}", (Object)LogUtils.buildLogContent(queryReqDto));
            List data = (List)RestResponseHelper.extractData((RestResponse)this.expressCostContractQueryApi.queryAreaByAreaNames(queryReqDto));
            log.info("\u67e5\u8be2\u5feb\u9012\u8d39\u7528\u533a\u57df\u8bbe\u7f6e\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(queryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)data) && CollectionUtils.isEmpty((Collection)(list = data.stream().filter(dto -> Objects.equals(receiveArea, dto.getArea())).collect(Collectors.toList())))) {
                list = data.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getArea())).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty((Collection)list)) {
                queryReqDto.setArea(null);
                queryReqDto.setCity(null);
                queryReqDto.setProvince(receiveProvince);
                log.info("\u901a\u8fc7\u5e02\u7ea7\u83b7\u53d6\u7701\u7ea7\u4fe1\u606f:{}", (Object)LogUtils.buildLogContent(queryReqDto));
                data = (List)RestResponseHelper.extractData((RestResponse)this.expressCostContractQueryApi.queryAreaByAreaNames(queryReqDto));
                log.info("\u901a\u8fc7\u5e02\u7ea7\u83b7\u53d6\u7701\u7ea7\u4fe1\u606f\u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(data));
                if (CollectionUtils.isNotEmpty((Collection)data) && CollectionUtils.isEmpty((Collection)(list = data.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getCity())).collect(Collectors.toList())))) {
                    list = Lists.newArrayList((Object[])new ExpressCostAreaRespDto[]{data.stream().max(Comparator.comparing(o -> null == o.getDay() ? -1 : o.getDay())).get()});
                }
            }
            log.info("\u67e5\u8be2\u5feb\u9012\u8d39\u7528\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)list));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                Integer day = ((ExpressCostAreaRespDto)list.get(0)).getDay();
                log.info("\u5feb\u9012\u8d39\u7528\u62c9\u53d6\u5230\u6240\u9700\u5929\u6570:{}", (Object)day);
                return null == day ? -1 : day;
            }
        } else if (Objects.equals(shipmentEnterpriseType, 1L)) {
            LogisticRecordExtReqDto reqDto = new LogisticRecordExtReqDto();
            reqDto.setLogisticCompanyName(csShipmenetEnterpriseEo.getShipmentEnterpriseName());
            reqDto.setWhCode(deliveryPhysicsWarehouseCode);
            reqDto.setOutWarehouseTime(new Date());
            reqDto.setTransportType(logisticsType);
            log.info("\u8fdb\u884c\u7269\u6d41\u6a21\u7248\u4fe1\u606f\u67e5\u8be2 \u53c2\u6570:{}", (Object)LogUtils.buildLogContent(reqDto));
            List logisticRecordQueryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.logisticQueryApi.queryList((List)Lists.newArrayList((Object[])new LogisticRecordExtReqDto[]{reqDto})));
            if (CollectionUtils.isEmpty((Collection)logisticRecordQueryRespDtoList)) {
                log.info("\u7269\u6d41\u6a21\u7248\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728....");
                return -1;
            }
            LogisticRecordQueryRespDto logisticRecordQueryRespDto = (LogisticRecordQueryRespDto)logisticRecordQueryRespDtoList.get(0);
            log.info("\u5e02\u533a\u57df\u4fe1\u606f:{},{}", (Object)receiveCity, (Object)receiveArea);
            AppointAreaQueryReqDto queryReqDto = new AppointAreaQueryReqDto();
            queryReqDto.setCity(receiveCity);
            queryReqDto.setTemplateId(String.valueOf(logisticRecordQueryRespDto.getId()));
            queryReqDto.setPageNum(Integer.valueOf(1));
            queryReqDto.setPageSize(Integer.valueOf(200));
            List<Object> list = Lists.newArrayList();
            log.info("\u67e5\u8be2\u7269\u6d41\u8d39\u7528\u5165\u53c2:{}", (Object)LogUtils.buildLogContent(queryReqDto));
            PageInfo data = (PageInfo)this.logisticQueryApi.queryAppointAreaList(queryReqDto).getData();
            log.info("\u67e5\u8be2\u7269\u6d41\u8d39\u7528\u7ed3\u679c: {}", (Object)LogUtils.buildLogContent(data.getList()));
            if (CollectionUtils.isNotEmpty((Collection)data.getList()) && CollectionUtils.isEmpty((Collection)(list = data.getList().stream().filter(dto -> Objects.equals(receiveArea, dto.getArea())).collect(Collectors.toList())))) {
                list = data.getList().stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getArea())).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty((Collection)list) && StringUtils.isNotBlank((CharSequence)receiveProvince)) {
                log.info("\u6839\u636e\u5e02\u4e00\u7ea7\u67e5\u8be2\u4e0d\u5230\u7269\u6d41\u8d39\u7528\uff0c\u6309\u7701\u4e00\u7ea7\u8fdb\u884c\u67e5\u8be2");
                queryReqDto.setArea(null);
                queryReqDto.setCity(null);
                queryReqDto.setProvince(receiveProvince);
                queryReqDto.setPageSize(Integer.valueOf(300));
                log.info("\u6309\u7701\u4e00\u7ea7\u67e5\u8be2\u7269\u6d41\u8d39\u7528 \u53c2\u6570:{}", (Object)LogUtils.buildLogContent(queryReqDto));
                data = (PageInfo)this.logisticQueryApi.queryAppointAreaList(queryReqDto).getData();
                log.info("\u6309\u7701\u4e00\u7ea7\u67e5\u8be2\u7269\u6d41\u8d39\u7528 \u7ed3\u679c:{}", (Object)LogUtils.buildLogContent(data.getList()));
                if (CollectionUtils.isNotEmpty((Collection)data.getList()) && CollectionUtils.isEmpty((Collection)(list = data.getList().stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getCity())).collect(Collectors.toList())))) {
                    list = Lists.newArrayList((Object[])new AppointAreaQueryRespDto[]{data.getList().stream().max(Comparator.comparing(o -> Integer.valueOf(((Object)o.getBizParams().getOrDefault("day", -1)).toString()))).get()});
                }
            }
            log.info("\u67e5\u8be2\u5feb\u9012\u8d39\u7528\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)list));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                int day;
                int n = day = null == ((AppointAreaQueryRespDto)list.get(0)).getDay() ? -1 : ((AppointAreaQueryRespDto)list.get(0)).getDay();
                if (day <= 0 && null != ((AppointAreaQueryRespDto)list.get(0)).getBizParams()) {
                    log.info("\u7269\u6d41\u9884\u8ba1\u5230\u8fbe\u5929\u6570\u53d6\u503c params.........");
                    day = Integer.parseInt(((AppointAreaQueryRespDto)list.get(0)).getBizParams().getOrDefault("day", "-1").toString());
                } else {
                    log.error("\u7269\u6d41\u9884\u8ba1\u5230\u8fbe\u5929\u6570\u53d6\u503c\u5f02\u5e38: {}", (Object)JSON.toJSONString(list));
                }
                log.info("\u5feb\u9012\u8d39\u7528\u62c9\u53d6\u5230\u6240\u9700\u5929\u6570:{}", (Object)day);
                return day;
            }
        }
        log.info("\u9884\u8ba1\u5230\u8fbe\u5929\u6570\u8ba1\u7b97\u5931\u8d25 \u5165\u53c2 carrierCode:{}, deliveryPhysicsWarehouseCode:{}, receiveArea:{}, receiveCity:{}, receiveProvince:{}, logisticsType:{}", new Object[]{carrierCode, deliveryPhysicsWarehouseCode, receiveArea, receiveCity, receiveProvince, logisticsType});
        return -1;
    }

    @Override
    public void syncAreaInfo(SyncAreaReqDto reqDto) {
        log.info("syncAreaInfo..................: {}", (Object)JSON.toJSONString((Object)reqDto));
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        DateTime beginDate = null;
        DateTime endDate = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)reqDto.getBeginTime())) {
                beginDate = DateUtil.parse((CharSequence)String.format("%s 00:00:00", reqDto.getBeginTime()));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)reqDto.getEndTime())) {
                endDate = DateUtil.parse((CharSequence)String.format("%s 23:59:59", reqDto.getEndTime()));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        List consignmentOrderAddressEos = this.consignmentOrderAddressMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderAddressEo.class).isNull(ConsignmentOrderAddressEo::getDistrictName)).eq(ConsignmentOrderAddressEo::getAddressType, (Object)"receive")).eq(StringUtils.isNotBlank((CharSequence)reqDto.getConsignmentNo()), ConsignmentOrderAddressEo::getConsignmentNo, (Object)reqDto.getConsignmentNo())).gt(null != beginDate, BaseEo::getCreateTime, (Object)beginDate)).lt(null != endDate, BaseEo::getCreateTime, (Object)endDate));
        PcpRegionReqDto pcpRegionReqDto = new PcpRegionReqDto();
        pcpRegionReqDto.setLevelId(Integer.valueOf(2));
        pcpRegionReqDto.setPageNum(Integer.valueOf(1));
        pcpRegionReqDto.setPageSize(Integer.valueOf(100000));
        PageInfo pcpRegionRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByPage(pcpRegionReqDto));
        List pcpRegionRespDtoList = pcpRegionRespDtoPageInfo.getList();
        log.info("pcpRegionRespDtoList : {}", (Object)JSON.toJSONString((Object)pcpRegionRespDtoList));
        for (ConsignmentOrderAddressEo eo : consignmentOrderAddressEos) {
            if (StringUtils.isBlank((CharSequence)eo.getDetailAddress())) continue;
            executorService.execute(() -> {
                if (StringUtils.isNotBlank((CharSequence)reqDto.getAreaName())) {
                    log.info("\u8fdb\u5165\u6307\u5b9a\u533a\u57df\u66f4\u65b0.........");
                    ConsignmentOrderAddressEo updateEo = new ConsignmentOrderAddressEo();
                    updateEo.setId(eo.getId());
                    updateEo.setDistrictName(reqDto.getAreaName());
                    this.consignmentOrderAddressDas.updateSelective((BaseEo)updateEo);
                    return;
                }
                for (PcpRegionRespDto o : pcpRegionRespDtoList) {
                    if (!StringUtils.equals((CharSequence)o.getParentCode(), (CharSequence)eo.getCityCode()) || !StringUtils.contains((CharSequence)eo.getDetailAddress(), (CharSequence)o.getName())) continue;
                    log.info("\u547d\u4e2d\u5730\u533a: {}", (Object)JSON.toJSONString((Object)o));
                    ConsignmentOrderAddressEo updateEo = new ConsignmentOrderAddressEo();
                    updateEo.setId(eo.getId());
                    updateEo.setDistrictName(o.getName());
                    this.consignmentOrderAddressDas.updateSelective((BaseEo)updateEo);
                    break;
                }
            });
        }
        executorService.shutdown();
    }

    @Override
    public ConsignmentDeliveryOrderRespDto queryOutDeliveryInfo(String outNoticeNo) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)outNoticeNo), "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ConsignmentDeliveryOrderRespDto respDto = this.consignmentOrderDas.queryOutDeliveryInfo(outNoticeNo);
        return respDto;
    }
}

