/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.dao.base.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.mapper.ItemMapper;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemSearchVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

@Service
public class ItemDas
extends AbstractBaseDas<ItemEo, String> {
    @Resource
    private ItemMapper itemMapper;

    public int updateStatusByIds(List<Long> itemIds, Integer status) {
        for (Long id : itemIds) {
            this.deleteCacheByKey(id.toString());
        }
        ItemMapper itemMapper = (ItemMapper)this.getMapper();
        return itemMapper.updateStatusByIds(itemIds, status);
    }

    public List<ItemEo> selectByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ItemEo itemEo = ItemEo.newInstance();
        itemEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        itemEo.setSqlFilters((List)sqlFilters);
        return this.select((BaseEo)itemEo);
    }

    public PageInfo<ItemEo> selectByKeyword(String keyword, Integer type, Long dirId, Long brandId, List<Map<String, String>> propList, Long sellerId, Long shopId, Integer pageNum, Integer pageSize, Long instanceId, Long tenantId) {
        ItemMapper itemMapper = (ItemMapper)this.getMapper();
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ItemEo> itemEoList = itemMapper.selectByKeyword(keyword, type, dirId, brandId, propList, sellerId, shopId, instanceId, tenantId);
        return new PageInfo(itemEoList);
    }

    public PageInfo<Long> querySaleOut(ItemEo query, int page, int size, List<Long> dirIdList) {
        ItemMapper mapper = (ItemMapper)this.getMapper();
        int count = mapper.querySaleOutCount(query, dirIdList);
        PageInfo info = new PageInfo();
        info.setTotal((long)count);
        info.setPageSize(size);
        info.setPageNum(page);
        if (count > 0) {
            int offset = (page - 1) * size;
            info.setList(mapper.querySaleOut(query, offset, size, dirIdList));
        }
        return info;
    }

    public void deleteCacheByKey(String key) {
        this.getCacheService().delCache(this.getCachePre() + key);
    }

    public PageInfo<ShelfItemVo> selectSelfItemByPage(ShelfItemVo shelfItemVo, Integer pageNum, Integer pageSize) {
        ItemMapper mapper = (ItemMapper)this.getMapper();
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfItemVo> shelfItemVoList = mapper.selectSelfItemByPage(shelfItemVo, pageNum, pageSize);
        return new PageInfo(shelfItemVoList);
    }

    public Long selectSelfItemCount(@Param(value="shelfItemVo") ShelfItemVo shelfItemVo) {
        ItemMapper mapper = (ItemMapper)this.getMapper();
        return mapper.selectSelfItems(shelfItemVo).size();
    }

    public List<ItemVo> pageItemOnSelf(ItemSearchVo managementBlockSearchVo) {
        return this.itemMapper.pageItemOnSelf(managementBlockSearchVo);
    }
}

