/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.biz.member.api.basis.enums;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.biz.member.api.basis.enums.MemberFreezeLoseEnum;
import com.dtyunxi.yundt.cube.biz.member.api.common.exception.ErrorCodeEnum;
import java.util.HashMap;
import java.util.Map;

public enum MemberStatusEnum {
    MEMBER_ACTIVATION(1, "\u6fc0\u6d3b"),
    MEMBER_FREEZE(2, "\u51bb\u7ed3"),
    MEMBER_CANCELLATION(3, "\u6ce8\u9500"),
    MEMBER_LOSE(4, "\u6302\u5931");

    private final Integer code;
    private final String description;
    public static Map<Integer, Map<Integer, String>> memberStatusRelationMap;

    private MemberStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static String getDescription(Integer code) {
        for (MemberStatusEnum memberStatusEnum : MemberStatusEnum.values()) {
            if (!memberStatusEnum.getCode().equals(code)) continue;
            return memberStatusEnum.getDescription();
        }
        return null;
    }

    public static Boolean isContain(Integer code) {
        for (MemberStatusEnum memberStatusEnum : MemberStatusEnum.values()) {
            if (!memberStatusEnum.getCode().equals(code)) continue;
            return true;
        }
        return false;
    }

    public static String getBeanName(Integer oldStatusCode, Integer updateStatusCode) {
        Map<Integer, String> map = memberStatusRelationMap.get(oldStatusCode);
        if (map == null || map.get(updateStatusCode) == null) {
            throw new BizException(ErrorCodeEnum.IMPROPER_PARAMETER.getErrorCode(), "\u4f1a\u5458\u72b6\u6001\u53d8\u66f4\u4e0d\u5408\u6cd5");
        }
        return map.get(updateStatusCode);
    }

    static {
        memberStatusRelationMap = new HashMap<Integer, Map<Integer, String>>();
        HashMap<Integer, String> activatMap = new HashMap<Integer, String>();
        activatMap.put(MEMBER_FREEZE.getCode(), MemberFreezeLoseEnum.MEMBER_FREEZE.getBeanName());
        activatMap.put(MEMBER_LOSE.getCode(), MemberFreezeLoseEnum.REPORT_LOSE_MEMBER.getBeanName());
        activatMap.put(MEMBER_CANCELLATION.getCode(), MemberFreezeLoseEnum.MEMBER_LOGOUT.getBeanName());
        memberStatusRelationMap.put(MEMBER_ACTIVATION.getCode(), activatMap);
        HashMap<Integer, String> freezeMap = new HashMap<Integer, String>();
        freezeMap.put(MEMBER_ACTIVATION.getCode(), MemberFreezeLoseEnum.EMBER_UNFREEZE.getBeanName());
        freezeMap.put(MEMBER_CANCELLATION.getCode(), MemberFreezeLoseEnum.MEMBER_LOGOUT.getBeanName());
        memberStatusRelationMap.put(MEMBER_FREEZE.getCode(), freezeMap);
        HashMap<Integer, String> loseMap = new HashMap<Integer, String>();
        loseMap.put(MEMBER_ACTIVATION.getCode(), MemberFreezeLoseEnum.RELIEVE_LOSE_MEMBER.getBeanName());
        loseMap.put(MEMBER_CANCELLATION.getCode(), MemberFreezeLoseEnum.MEMBER_LOGOUT.getBeanName());
        memberStatusRelationMap.put(MEMBER_LOSE.getCode(), loseMap);
        HashMap logOutMember = new HashMap();
        memberStatusRelationMap.put(MEMBER_CANCELLATION.getCode(), logOutMember);
    }
}

