/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.biz.member.api.common.constants.enums.member;

import java.util.Arrays;
import java.util.Optional;

public enum IncomeEnum {
    INCOME_1("10", "\u5c11\u4e8e3\u4e07"),
    INCOME_2("20", "3\u4e07-6\u4e07"),
    INCOME_3("30", "6\u4e07-10\u4e07"),
    INCOME_4("40", "10\u4e07-15\u4e07"),
    INCOME_5("50", "15\u4e07-25\u4e07"),
    INCOME_6("60", "\u8d85\u8fc725\u4e07");

    private final String code;
    private final String name;

    private IncomeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static boolean containCode(String code) {
        Optional<IncomeEnum> result = Arrays.stream(IncomeEnum.values()).filter(incomeEnum -> incomeEnum.getCode().equals(code)).findAny();
        return result.isPresent();
    }

    public static boolean containName(String name) {
        Optional<IncomeEnum> result = Arrays.stream(IncomeEnum.values()).filter(incomeEnum -> incomeEnum.getName().equals(name)).findAny();
        return result.isPresent();
    }

    public static Integer getCodeByName(String name) {
        Optional<IncomeEnum> result = Arrays.stream(IncomeEnum.values()).filter(incomeEnum -> incomeEnum.getName().equals(name)).findAny();
        if (result.isPresent()) {
            return Integer.parseInt(result.get().getCode());
        }
        return null;
    }
}

