/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.biz.member.api.common.constants.enums.member;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

public enum MemberTypeEnum {
    STAFF_MEMBER("1", "\u5458\u5de5\u4f1a\u5458"),
    ORDINARY_MEMBER("2", "\u666e\u901a\u4f1a\u5458");

    private final String code;
    private final String name;
    private static Map<String, MemberTypeEnum> codeMap;

    private MemberTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static boolean containCode(String code) {
        Optional<MemberTypeEnum> result = Arrays.stream(MemberTypeEnum.values()).filter(memberTypeEnum -> memberTypeEnum.getCode().equals(code)).findAny();
        return result.isPresent();
    }

    public static boolean containName(String name) {
        Optional<MemberTypeEnum> result = Arrays.stream(MemberTypeEnum.values()).filter(memberTypeEnum -> memberTypeEnum.getName().equals(name)).findAny();
        return result.isPresent();
    }

    public static Integer getCodeByName(String name) {
        Optional<MemberTypeEnum> result = Arrays.stream(MemberTypeEnum.values()).filter(memberTypeEnum -> memberTypeEnum.getName().equals(name)).findAny();
        if (result.isPresent()) {
            return Integer.parseInt(result.get().getCode());
        }
        return null;
    }

    public static MemberTypeEnum getByCode(String code) {
        return codeMap.get(code);
    }

    static {
        codeMap = Maps.newHashMap();
        codeMap.put(STAFF_MEMBER.getCode(), STAFF_MEMBER);
        codeMap.put(ORDINARY_MEMBER.getCode(), ORDINARY_MEMBER);
    }
}

