/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.biz.member.api.common.util;

import com.dtyunxi.yundt.cube.biz.member.api.common.constants.enums.ModuleType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CenterMemberCheckUtil {
    protected static final String HEALTHY_CHECK_LOG_PREFIX = "[center_member_healthy_check]-";
    private static Logger logger = LoggerFactory.getLogger(CenterMemberCheckUtil.class);
    private static List<ModuleType> loadModules = new ArrayList<ModuleType>();

    public static boolean isLoadModule(ModuleType moduleType) {
        for (ModuleType loadModule : loadModules) {
            if (loadModule.getCode() != moduleType.getCode()) continue;
            return true;
        }
        return false;
    }

    protected static void addLoadModule(ModuleType moduleType) {
        loadModules.add(moduleType);
        logger.info("[center_member_healthy_check]-\u4f1a\u5458\u4e2d\u5fc3\u52a0\u8f7d\u4e86\u6a21\u5757\u3010{}\u3011", (Object)moduleType.getDesc());
    }

    protected static void addLoadModules(List<ModuleType> moduleTypes) {
        if (null == moduleTypes) {
            return;
        }
        loadModules.addAll(moduleTypes);
        logger.info("[center_member_healthy_check]-\u4f1a\u5458\u4e2d\u5fc3\u52a0\u8f7d\u4e86\u6a21\u5757\u3010{}\u3011", (Object)CenterMemberCheckUtil.genAllModuleDesc(moduleTypes));
    }

    protected static void addNewLoadModules(List<ModuleType> moduleTypes) {
        if (null == moduleTypes) {
            return;
        }
        boolean isSame = CenterMemberCheckUtil.isSameModules(loadModules, moduleTypes);
        if (!isSame) {
            loadModules.clear();
            loadModules.addAll(moduleTypes);
            logger.info("[center_member_healthy_check]-\u4f1a\u5458\u4e2d\u5fc3\u52a0\u8f7d\u4e86\u5168\u65b0\u6a21\u5757\u3010{}\u3011", (Object)CenterMemberCheckUtil.genAllModuleDesc(moduleTypes));
        }
    }

    private static boolean isSameModules(List<ModuleType> loadModules, List<ModuleType> moduleTypes) {
        if (loadModules.size() != moduleTypes.size()) {
            return false;
        }
        for (ModuleType loadModule : loadModules) {
            boolean isExist = false;
            for (ModuleType tmpModule : moduleTypes) {
                if (loadModule.getCode() != tmpModule.getCode()) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            return false;
        }
        return true;
    }

    private static String genAllModuleDesc(List<ModuleType> moduleTypes) {
        if (null == moduleTypes) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < moduleTypes.size(); ++i) {
            ModuleType moduleType = moduleTypes.get(i);
            sb.append(moduleType.getDesc());
            if (i == moduleTypes.size() - 1) continue;
            sb.append("||");
        }
        return sb.toString();
    }
}

