/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.biz.member.api.common.util;

import com.dtyunxi.yundt.cube.biz.member.api.common.dto.ModuleCheckInfo;
import com.dtyunxi.yundt.cube.biz.member.api.common.service.ICenterMemberHealthyCheckApi;
import com.dtyunxi.yundt.cube.biz.member.api.common.util.CenterMemberCheckUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class CenterMemberHealthyCheckSupport
implements InitializingBean {
    private static int interval = 30000;
    private Logger logger = LoggerFactory.getLogger(CenterMemberHealthyCheckSupport.class);
    @Autowired
    private ICenterMemberHealthyCheckApi centerMemberHealthyCheckApi;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    public void afterPropertiesSet() throws Exception {
        this.executorService.submit(() -> this.momitor());
        int i = 0;
        while (i < 5) {
            final int finalI = i++;
            Future<String> future = this.executorService.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return "res" + finalI;
                }
            });
        }
    }

    private void momitor() {
        while (true) {
            ModuleCheckInfo checkInfo = null;
            try {
                checkInfo = this.centerMemberHealthyCheckApi.checkModule();
                CenterMemberCheckUtil.addNewLoadModules(checkInfo.getLoadModules());
            }
            catch (Exception e) {
                this.logger.error("[center_member_healthy_check]-\u65e0\u6cd5\u8fde\u63a5\u4f1a\u5458\u4e2d\u5fc3\u5065\u5eb7\u68c0\u67e5\u670d\u52a1");
            }
            try {
                Thread.sleep(interval);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error("[center_member_healthy_check]-\u4f1a\u5458\u4e2d\u5fc3\u5065\u5eb7\u68c0\u6d4bMonitor\u88ab\u6253\u65ad\uff0c", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

