/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.client;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.cube.center.scheduler.client.util.ConfigHelper;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.HeartMsg;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Configurable
@EnableScheduling
public class HeartHandler {
    private static Logger logger = LoggerFactory.getLogger(HeartHandler.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ConfigHelper configHelper;

    @Scheduled(initialDelay=10000L, fixedDelay=60000L)
    public void send() {
        logger.debug("----------> \u53d1\u9001\u5fc3\u8df3\u5f00\u59cb..");
        String appCode = this.configHelper.getAppCode();
        if (StringUtils.isBlank((CharSequence)appCode)) {
            return;
        }
        String ip = "";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error("\u83b7\u53d6\u672c\u673aIP\u5931\u8d25");
        }
        HeartMsg heartMsg = new HeartMsg(appCode, ip, Long.valueOf(System.currentTimeMillis()));
        this.commonsMqService.sendSingleMessage("SCHEDULER-HEART", (Object)heartMsg);
        logger.debug("----------> \u53d1\u9001\u5fc3\u8df3\u5b8c\u6bd5!");
    }
}

