/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.api.util;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPropertyNullUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanPropertyNullUtil.class);

    public static <T> boolean isAllFieldNull(T obj) {
        if (null == obj) {
            return true;
        }
        Class<?> stuCla = obj.getClass();
        Field[] fs = stuCla.getDeclaredFields();
        boolean flag = true;
        for (Field f : fs) {
            f.setAccessible(true);
            Object val = null;
            try {
                val = f.get(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027\u503c\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            if (val == null) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static <T> List<T> getAllFieldNullList(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            list = Lists.newArrayList();
        }
        list = list.stream().filter(dto -> !BeanPropertyNullUtil.isAllFieldNull(dto)).collect(Collectors.toList());
        return list;
    }
}

