/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.api.util;

import com.dtyunxi.yundt.cube.center.user.api.annotation.DefaultTranslate;
import com.dtyunxi.yundt.cube.center.user.api.annotation.Translate;
import com.dtyunxi.yundt.cube.center.user.api.util.LoggerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class ReflectionUtils {
    private static Consumer<String> LOGGER = LoggerUtil::printLog;
    private static BiConsumer<String, LoggerUtil.Level> ERROR_LOG = LoggerUtil::printLog;

    @Nullable
    @CheckReturnValue
    public static Object getFieldValue(@NonNull Object obj, @NonNull String fieldName) {
        Field field = ReflectionUtils.getAccessField(obj, fieldName);
        if (field != null) {
            try {
                return field.get(obj);
            }
            catch (IllegalAccessException e) {
                ERROR_LOG.accept("failed to get object", LoggerUtil.Level.error);
            }
        }
        return null;
    }

    public static <E> String getField(@NonNull E dto, @NonNull String fieldName) {
        Field field = ReflectionUtils.getAccessField(dto, fieldName);
        if (field != null) {
            Object obj = null;
            try {
                obj = field.get(dto);
            }
            catch (IllegalAccessException e) {
                ERROR_LOG.accept("failed to get object", LoggerUtil.Level.error);
            }
            Translate annotation = field.getAnnotation(Translate.class);
            return ReflectionUtils.translateAnnotation(annotation, obj);
        }
        return "";
    }

    private static String translateAnnotation(Translate annotation, Object obj) {
        if (null != annotation) {
            Class<? extends DefaultTranslate> clazz = annotation.clazz();
            if (DefaultTranslate.class.equals(clazz)) {
                return annotation.translate().translate(obj);
            }
            try {
                DefaultTranslate defaultTranslate1 = clazz.newInstance();
                return defaultTranslate1.defaultTranslate(obj);
            }
            catch (Exception e) {
                ERROR_LOG.accept("failed to new Instance", LoggerUtil.Level.error);
                return "";
            }
        }
        return null == obj ? "" : obj.toString();
    }

    @CheckReturnValue
    @Nullable
    private static Field getAccessField(@NonNull Object obj, @NonNull String fieldName) {
        Optional.ofNullable(obj).orElseThrow(() -> {
            LOGGER.accept("check object is null");
            return new NullPointerException("check object is null");
        });
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new NullPointerException("get field is blank");
        }
        for (Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                if (field == null) continue;
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                ERROR_LOG.accept(clazz.getSimpleName() + " Class no such method", LoggerUtil.Level.error);
            }
        }
        return null;
    }

    public static List<Field> getAllDeclaredFields(Class<?> aClass) {
        ArrayList<Field> list = new ArrayList<Field>();
        Class<?> currentClass = aClass;
        while (currentClass != null) {
            Field[] declareField = currentClass.getDeclaredFields();
            list.addAll(Arrays.asList(declareField));
            currentClass = aClass.getSuperclass();
        }
        return list;
    }

    public static String getFeildValue(Object o, Translate annotation) {
        if (null == o) {
            return "\u65e0";
        }
        if (DefaultTranslate.class.equals(annotation.clazz())) {
            return annotation.translate().translate(o);
        }
        try {
            return annotation.clazz().newInstance().defaultTranslate(o);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return "\u65e0";
        }
    }
}

