/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.module.track.service.impl;

import com.dtyunxi.cube.center.track.api.ITransactionApi;
import com.dtyunxi.cube.center.track.api.dto.request.TransactionReqDto;
import com.dtyunxi.cube.component.track.commons.exception.TransactionException;
import com.dtyunxi.cube.component.track.commons.exception.TransactionExceptionCode;
import com.dtyunxi.cube.component.track.commons.utils.CommonUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionVo;
import com.dtyunxi.cube.module.track.service.ITransactionRegisterService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TransactionRegisterServiceImpl
implements ITransactionRegisterService {
    @Resource
    private ITransactionApi transactionApiImpl;

    @Override
    public TransactionVo registerTransaction(TransactionVo transactionVo) {
        TransactionReqDto reqDto = new TransactionReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)transactionVo, (String[])new String[0]);
        Long registerId = (Long)CommonUtils.checkResponse((RestResponse)this.transactionApiImpl.addTransaction(reqDto));
        if (registerId == null) {
            throw new TransactionException(TransactionExceptionCode.REGISTER_RESULT_NULL);
        }
        transactionVo.setId(registerId);
        return transactionVo;
    }

    @Override
    public void modifyTransaction(TransactionVo transactionVo) {
        TransactionReqDto reqDto = new TransactionReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)transactionVo, (String[])new String[0]);
        CommonUtils.checkResponse((RestResponse)this.transactionApiImpl.modifyTransaction(reqDto));
    }
}

