/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WrapperHandlingDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 1L;
    protected final Set<String> _namesToWrap;
    protected final JavaType _type;

    public WrapperHandlingDeserializer(BeanDeserializerBase delegate) {
        this(delegate, null);
    }

    public WrapperHandlingDeserializer(BeanDeserializerBase delegate, Set<String> namesToWrap) {
        super((JsonDeserializer)delegate);
        this._namesToWrap = namesToWrap;
        this._type = delegate.getValueType();
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee0) {
        throw new IllegalStateException("Internal error: should never get called");
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer del = ctxt.handleSecondaryContextualization(this._delegatee, property, this._type);
        BeanDeserializerBase newDelegatee = this._verifyDeserType(del);
        Iterator it = newDelegatee.properties();
        HashSet<String> unwrappedNames = null;
        while (it.hasNext()) {
            PropertyName wrapperName;
            SettableBeanProperty prop = (SettableBeanProperty)it.next();
            JavaType type = prop.getType();
            if (!TypeUtil.isIndexedType(type) || (wrapperName = prop.getWrapperName()) != null && wrapperName != PropertyName.NO_NAME) continue;
            if (unwrappedNames == null) {
                unwrappedNames = new HashSet<String>();
            }
            unwrappedNames.add(prop.getName());
        }
        if (unwrappedNames == null) {
            return newDelegatee;
        }
        return new WrapperHandlingDeserializer(newDelegatee, unwrappedNames);
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        this._configureParser(jp);
        return this._delegatee.deserialize(jp, ctxt);
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt, Object intoValue) throws IOException {
        this._configureParser(jp);
        return this._delegatee.deserialize(jp, ctxt, intoValue);
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        this._configureParser(jp);
        return this._delegatee.deserializeWithType(jp, ctxt, typeDeserializer);
    }

    protected final void _configureParser(JsonParser jp) throws IOException {
        if (jp instanceof FromXmlParser) {
            ((FromXmlParser)jp).addVirtualWrapping(this._namesToWrap);
        }
    }

    protected BeanDeserializerBase _verifyDeserType(JsonDeserializer<?> deser) {
        if (!(deser instanceof BeanDeserializerBase)) {
            throw new IllegalArgumentException("Can not change delegate to be of type " + deser.getClass().getName());
        }
        return (BeanDeserializerBase)deser;
    }
}

