/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.cache;

import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.cache.Cacheable;
import com.foxinmy.weixin4j.util.SerializationUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileCacheStorager<T extends Cacheable>
implements CacheStorager<T> {
    private final File tmpdir;
    private final String SEPARATOR = File.separator;

    public FileCacheStorager() {
        this(System.getProperty("java.io.tmpdir"));
    }

    public FileCacheStorager(String path) {
        this.tmpdir = new File(String.format("%s%s%s", path, this.SEPARATOR, "weixin4j_cache_keys"));
        this.tmpdir.mkdirs();
    }

    @Override
    public T lookup(String key) {
        File cacheFile = new File(String.format("%s%s%s", this.tmpdir.getAbsolutePath(), this.SEPARATOR, key));
        try {
            if (cacheFile.exists()) {
                Cacheable cache = (Cacheable)SerializationUtils.deserialize(new FileInputStream(cacheFile));
                if (cache.getExpires() < 0L) {
                    return (T)cache;
                }
                if (cache.getCreateTime() + cache.getExpires() - 60000L > System.currentTimeMillis()) {
                    return (T)cache;
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void caching(String key, T cache) {
        try {
            SerializationUtils.serialize(cache, new FileOutputStream(new File(String.format("%s%s%s", this.tmpdir.getAbsolutePath(), this.SEPARATOR, key))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T evict(String key) {
        Cacheable cache = null;
        File cacheFile = new File(String.format("%s%s%s", this.tmpdir.getAbsolutePath(), this.SEPARATOR, key));
        try {
            if (cacheFile.exists()) {
                cache = (Cacheable)SerializationUtils.deserialize(new FileInputStream(cacheFile));
                cacheFile.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (T)cache;
    }

    @Override
    public void clear() {
        for (File cache : this.tmpdir.listFiles()) {
            cache.delete();
        }
    }
}

