/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.apache.mime;

import com.foxinmy.weixin4j.http.ContentType;
import com.foxinmy.weixin4j.http.apache.mime.AbstractMultipartForm;
import com.foxinmy.weixin4j.http.entity.HttpEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class MultipartFormEntity
implements HttpEntity {
    private final AbstractMultipartForm multipart;
    private final ContentType contentType;
    private final long contentLength;

    MultipartFormEntity(AbstractMultipartForm multipart, ContentType contentType, long contentLength) {
        this.multipart = multipart;
        this.contentType = contentType;
        this.contentLength = contentLength;
    }

    AbstractMultipartForm getMultipart() {
        return this.multipart;
    }

    public boolean isRepeatable() {
        return this.contentLength != -1L;
    }

    public boolean isChunked() {
        return !this.isRepeatable();
    }

    public boolean isStreaming() {
        return !this.isRepeatable();
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.contentLength < 0L) {
            throw new IllegalArgumentException("Content length is unknown");
        }
        if (this.contentLength > 0x500000L) {
            throw new IllegalArgumentException("Content length is too long: " + this.contentLength);
        }
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        this.writeTo(outstream);
        outstream.flush();
        return new ByteArrayInputStream(outstream.toByteArray());
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        this.multipart.writeTo(outstream);
    }
}

