/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.message;

import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.MimeType;
import com.foxinmy.weixin4j.http.message.MessageConverter;
import com.foxinmy.weixin4j.util.Consts;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractMessageConverter
implements MessageConverter {
    protected Charset charset = Consts.UTF_8;
    private List<MimeType> supportedMimeTypes;

    protected AbstractMessageConverter() {
        this.supportedMimeTypes = Collections.emptyList();
    }

    protected AbstractMessageConverter(MimeType supportedMimeType) {
        this.setSupportedMediaTypes(Collections.singletonList(supportedMimeType));
    }

    protected AbstractMessageConverter(MimeType ... supportedMimeTypes) {
        this.setSupportedMediaTypes(Arrays.asList(supportedMimeTypes));
    }

    public void setSupportedMediaTypes(List<MimeType> supportedMimeTypes) {
        this.supportedMimeTypes = new ArrayList<MimeType>(supportedMimeTypes);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public List<MimeType> supportedMimeTypes() {
        return Collections.unmodifiableList(this.supportedMimeTypes);
    }

    @Override
    public boolean canConvert(Class<?> clazz, HttpResponse response) {
        MimeType mimeType = MimeType.valueOf(response.getHeaders().getContentType());
        byte[] content = response.getContent();
        return this.supports(clazz, mimeType) || this.supports(clazz, content);
    }

    protected boolean supports(Class<?> clazz, MimeType mimeType) {
        if (mimeType == null) {
            return true;
        }
        for (MimeType supportedMediaType : this.supportedMimeTypes()) {
            if (!supportedMediaType.includes(mimeType)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean supports(Class<?> var1, byte[] var2);

    @Override
    public <T> T convert(Class<? extends T> clazz, HttpResponse response) throws IOException {
        return this.convertInternal(clazz, response.getBody());
    }

    protected abstract <T> T convertInternal(Class<? extends T> var1, InputStream var2) throws IOException;
}

