/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.message;

import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.MimeType;
import com.foxinmy.weixin4j.http.message.AbstractMessageConverter;
import com.foxinmy.weixin4j.util.FileUtil;
import com.foxinmy.weixin4j.util.RegexUtil;
import com.foxinmy.weixin4j.xml.XmlStream;
import java.io.IOException;
import java.io.InputStream;

public class XmlMessageConverter
extends AbstractMessageConverter {
    public static final XmlMessageConverter GLOBAL = new XmlMessageConverter();
    private static final String XML = "xml";
    private static final int BRACKET = 60;

    public XmlMessageConverter() {
        super(MimeType.APPLICATION_XML, MimeType.TEXT_XML, new MimeType("application", "*+xml"));
    }

    @Override
    public boolean canConvert(Class<?> clazz, HttpResponse response) {
        if (!super.canConvert(clazz, response)) {
            String disposition = response.getHeaders().getFirst("Content-Disposition");
            String fileName = RegexUtil.regexFileNameFromContentDispositionHeader(disposition);
            return fileName != null && FileUtil.getFileExtension(fileName).equalsIgnoreCase(XML);
        }
        return true;
    }

    @Override
    protected boolean supports(Class<?> clazz, byte[] content) {
        return 60 == content[0];
    }

    @Override
    protected <T> T convertInternal(Class<? extends T> clazz, InputStream body) throws IOException {
        return XmlStream.fromXML(body, clazz);
    }
}

