/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.support.okhttp;

import com.foxinmy.weixin4j.http.HttpClient;
import com.foxinmy.weixin4j.http.HttpParams;
import com.foxinmy.weixin4j.http.factory.HttpClientFactory;
import com.foxinmy.weixin4j.http.support.okhttp.OkHttpClient3;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpClient3Factory
extends HttpClientFactory {
    private volatile OkHttpClient okClient;
    private final OkHttpClient.Builder clientBuilder;

    public OkHttpClient3Factory() {
        this.clientBuilder = new OkHttpClient.Builder();
        this.clientBuilder.hostnameVerifier(HttpClientFactory.AllowHostnameVerifier.GLOBAL);
        this.clientBuilder.sslSocketFactory(HttpClientFactory.allowSSLContext().getSocketFactory(), HttpClientFactory.AllowX509TrustManager.GLOBAL);
    }

    public OkHttpClient3Factory(OkHttpClient.Builder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    private void resolveHttpParams(HttpParams params) {
        if (params != null) {
            this.clientBuilder.connectTimeout((long)params.getConnectTimeout(), TimeUnit.MILLISECONDS);
            this.clientBuilder.readTimeout((long)params.getReadTimeout(), TimeUnit.MILLISECONDS);
            if (params.getProxy() != null) {
                this.clientBuilder.proxy(params.getProxy());
            }
            if (params.getSSLContext() != null) {
                this.clientBuilder.sslSocketFactory(params.getSSLContext().getSocketFactory(), HttpClientFactory.AllowX509TrustManager.GLOBAL);
            }
            if (params.getHostnameVerifier() != null) {
                this.clientBuilder.hostnameVerifier(params.getHostnameVerifier());
            }
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(params.getMaxConnections());
            dispatcher.setMaxRequestsPerHost(params.getMaxConnectionsPerHost());
            this.clientBuilder.dispatcher(dispatcher);
        }
    }

    public OkHttpClient3Factory setWriteTimeout(int writeTimeout) {
        this.clientBuilder.writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public OkHttpClient3Factory addInterceptor(Interceptor interceptor) {
        this.clientBuilder.addInterceptor(interceptor);
        return this;
    }

    public OkHttpClient3Factory retryOnConnectionFailure(boolean retryOnConnectionFailure) {
        this.clientBuilder.retryOnConnectionFailure(retryOnConnectionFailure);
        return this;
    }

    public OkHttpClient3Factory setCookieJar(CookieJar cookieJar) {
        this.clientBuilder.cookieJar(cookieJar);
        return this;
    }

    public OkHttpClient3Factory setCache(Cache cache) {
        this.clientBuilder.cache(cache);
        return this;
    }

    public OkHttpClient3Factory setConnectionPool(ConnectionPool connectionPool) {
        this.clientBuilder.connectionPool(connectionPool);
        return this;
    }

    public OkHttpClient3Factory setDispatcher(Dispatcher dispatcher) {
        this.clientBuilder.dispatcher(dispatcher);
        return this;
    }

    public OkHttpClient3Factory setDns(Dns dns) {
        this.clientBuilder.dns(dns);
        return this;
    }

    @Override
    public HttpClient newInstance(HttpParams params) {
        this.resolveHttpParams(params);
        if (this.okClient == null) {
            this.okClient = this.clientBuilder.build();
        }
        return new OkHttpClient3(this.okClient);
    }
}

