/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.weixin;

import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.HttpClient;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.HttpMethod;
import com.foxinmy.weixin4j.http.HttpParams;
import com.foxinmy.weixin4j.http.HttpRequest;
import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.MimeType;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.apache.mime.FormBodyPart;
import com.foxinmy.weixin4j.http.apache.mime.HttpMultipartMode;
import com.foxinmy.weixin4j.http.apache.mime.MultipartEntityBuilder;
import com.foxinmy.weixin4j.http.entity.FormUrlEntity;
import com.foxinmy.weixin4j.http.entity.StringEntity;
import com.foxinmy.weixin4j.http.factory.HttpClientFactory;
import com.foxinmy.weixin4j.http.message.XmlMessageConverter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.http.weixin.XmlResult;
import com.foxinmy.weixin4j.logging.InternalLogLevel;
import com.foxinmy.weixin4j.logging.InternalLogger;
import com.foxinmy.weixin4j.logging.InternalLoggerFactory;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class WeixinRequestExecutor {
    protected final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private static final String SUCCESS_CODE = ",0,success,";
    private final HttpClient httpClient;
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);

    public WeixinRequestExecutor() {
        this.httpClient = HttpClientFactory.getInstance();
    }

    public WeixinRequestExecutor(HttpParams params) {
        this.httpClient = HttpClientFactory.getInstance(params);
    }

    public WeixinResponse post(String url, String body) throws WeixinException {
        StringEntity entity = new StringEntity(body);
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setEntity(entity);
        return this.doRequest(request);
    }

    public WeixinResponse post(String url, FormBodyPart ... bodyParts) throws WeixinException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        for (FormBodyPart bodyPart : bodyParts) {
            builder.addPart(bodyPart);
        }
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setEntity(builder.setMode(HttpMultipartMode.RFC6532).buildEntity());
        return this.doRequest(request);
    }

    public WeixinResponse get(String url, URLParameter ... parameters) throws WeixinException {
        StringBuilder buf = new StringBuilder(url);
        if (parameters != null && parameters.length > 0) {
            buf.append("&").append(FormUrlEntity.formatParameters(Arrays.asList(parameters)));
        }
        HttpRequest request = new HttpRequest(HttpMethod.GET, buf.toString());
        return this.doRequest(request);
    }

    public WeixinResponse doRequest(HttpRequest request) throws WeixinException {
        try {
            if (this.logger.isEnabled(InternalLogLevel.DEBUG)) {
                this.logger.debug("weixin request >> " + (Object)((Object)request.getMethod()) + " " + request.getURI().toString() + (request.getEntity() instanceof StringEntity ? " >> " + ((StringEntity)request.getEntity()).getContentString() : ""));
            }
            HttpResponse httpResponse = this.httpClient.execute(request);
            WeixinResponse response = new WeixinResponse(httpResponse);
            this.handleResponse(response);
            return response;
        }
        catch (HttpClientException e) {
            throw new WeixinException(e);
        }
    }

    private boolean hasStreamMimeType(WeixinResponse response) {
        MimeType responseMimeType = MimeType.valueOf(response.getHeaders().getContentType());
        for (MimeType streamMimeType : MimeType.STREAM_MIMETYPES) {
            if (!streamMimeType.includes(responseMimeType)) continue;
            return true;
        }
        return false;
    }

    protected void handleResponse(WeixinResponse response) throws WeixinException {
        boolean hasStreamMimeType = this.hasStreamMimeType(response);
        if (this.logger.isEnabled(InternalLogLevel.DEBUG)) {
            this.logger.debug("weixin response << " + response.getProtocol() + response.getStatus() + " << " + (hasStreamMimeType ? response.getHeaders().getContentType() : response.getAsString()));
        }
        if (hasStreamMimeType) {
            return;
        }
        ApiResult result = response.getAsResult();
        if (!SUCCESS_CODE.contains(String.format(",%s,", result.getReturnCode().toLowerCase()))) {
            throw new WeixinException(result.getReturnCode(), result.getReturnMsg());
        }
        if (XmlMessageConverter.GLOBAL.canConvert(XmlResult.class, response)) {
            try {
                XmlResult xmlResult = XmlMessageConverter.GLOBAL.convert(XmlResult.class, response);
                if (StringUtil.isNotBlank(xmlResult.getResultCode()) && !SUCCESS_CODE.contains(String.format(",%s,", xmlResult.getResultCode().toLowerCase()))) {
                    throw new WeixinException(xmlResult.getErrCode(), xmlResult.getErrCodeDes());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public HttpClient getExecuteClient() {
        return this.httpClient;
    }

    public WeixinRequestExecutor createSSLRequestExecutor(String password, InputStream inputStream) throws WeixinException {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(inputStream, password.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, password.toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            return this.createSSLRequestExecutor(sslContext);
        }
        catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new WeixinException("Key load error", e);
        }
    }

    public WeixinRequestExecutor createSSLRequestExecutor(SSLContext sslContext) {
        if (sslContext == null) {
            throw new IllegalArgumentException("sslContext must not be empty");
        }
        HttpParams params = new HttpParams();
        params.setSSLContext(sslContext);
        return new WeixinRequestExecutor(params);
    }

    public WeixinRequestExecutor createSSLRequestExecutor(String password, String pemCertificate, String pemPrivateKey) throws WeixinException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            byte[] certBytes = WeixinRequestExecutor.parseDERFromPEM(pemCertificate);
            byte[] keyBytes = WeixinRequestExecutor.parseDERFromPEM(pemPrivateKey);
            char[] passwordChars = password.toCharArray();
            X509Certificate cert = WeixinRequestExecutor.generateCertificateFromDER(certBytes);
            RSAPrivateKey key = WeixinRequestExecutor.generatePrivateKeyFromDER(keyBytes);
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(null);
            keystore.setCertificateEntry("cert-alias", cert);
            keystore.setKeyEntry("key-alias", key, passwordChars, new X509Certificate[]{cert});
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keystore, passwordChars);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(kmf.getKeyManagers(), null, new SecureRandom());
            return this.createSSLRequestExecutor(context);
        }
        catch (Exception e) {
            throw new WeixinException("Certificate load error", e);
        }
    }

    private static byte[] parseDERFromPEM(String data) throws KeyStoreException {
        Matcher matcher = CERT_PATTERN.matcher(data);
        String content = "";
        if (!matcher.find() && !(matcher = KEY_PATTERN.matcher(data)).find()) {
            throw new KeyStoreException("found no private key or certificate from content:" + data);
        }
        content = matcher.group(1);
        return DatatypeConverter.parseBase64Binary((String)content);
    }

    private static RSAPrivateKey generatePrivateKeyFromDER(byte[] keyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    protected static X509Certificate generateCertificateFromDER(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }
}

