/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model;

import com.foxinmy.weixin4j.cache.Cacheable;
import java.util.HashMap;
import java.util.Map;

public class Token
implements Cacheable {
    private static final long serialVersionUID = -7564855472419104084L;
    private String accessToken;
    private long expires;
    private long createTime;
    private Map<String, String> extra;

    public Token(String accessToken) {
        this(accessToken, -1L);
    }

    public Token(String accessToken, long expires) {
        this(accessToken, expires, System.currentTimeMillis());
    }

    public Token(String accessToken, long expires, long createTime) {
        this.accessToken = accessToken;
        this.expires = expires;
        this.createTime = createTime;
        this.extra = new HashMap<String, String>();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public long getExpires() {
        return this.expires;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public Token pushExtra(String name, String value) {
        this.extra.put(name, value);
        return this;
    }

    public String toString() {
        return "Token [accessToken=" + this.accessToken + ", expires=" + this.expires + ", createTime=" + this.createTime + ", extra=" + this.extra + "]";
    }
}

