/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model.card;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.model.card.CardCoupon;
import com.foxinmy.weixin4j.model.card.CouponBaseInfo;
import com.foxinmy.weixin4j.type.card.CardType;
import com.foxinmy.weixin4j.util.DateUtil;

public class CashCoupon
extends CardCoupon {
    @JSONField(name="least_cost")
    private int leastCost;
    @JSONField(name="reduce_cost")
    private final int reduceCost;

    public CashCoupon(CouponBaseInfo couponBaseInfo, double reduceCost) {
        super(couponBaseInfo);
        this.reduceCost = DateUtil.formatYuan2Fen(reduceCost);
    }

    public int getLeastCost() {
        return this.leastCost;
    }

    @JSONField(serialize=false)
    public double getFormatLeastCost() {
        return (double)this.leastCost / 100.0;
    }

    public void setLeastCost(double leastCost) {
        this.leastCost = DateUtil.formatYuan2Fen(this.reduceCost);
    }

    public int getReduceCost() {
        return this.reduceCost;
    }

    @JSONField(serialize=false)
    public double getFormatReduceCost() {
        return (double)this.reduceCost / 100.0;
    }

    @Override
    @JSONField(serialize=false)
    public CardType getCardType() {
        return CardType.CASH;
    }

    @Override
    public String toString() {
        return "CashCoupon [leastCost=" + this.leastCost + ", reduceCost=" + this.reduceCost + ", " + super.toString() + "]";
    }
}

