/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model.card;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.model.card.CardCoupon;
import com.foxinmy.weixin4j.model.card.CouponBaseInfo;
import com.foxinmy.weixin4j.model.card.MemCardCustomField;
import com.foxinmy.weixin4j.type.card.CardType;
import com.foxinmy.weixin4j.type.card.SubCardType;

public class GiftCard
extends CardCoupon {
    @JSONField(name="sub_card_type")
    private final String subCardType = SubCardType.VOUCHER.name();
    @JSONField(name="background_pic_url")
    private String backgroundPicUrl;
    @JSONField(name="supply_bonus")
    private boolean supplyBonus;
    @JSONField(name="supply_balance")
    private boolean supplyBalance;
    @JSONField(name="custom_field1")
    private MemCardCustomField customField1;
    @JSONField(name="custom_field2")
    private MemCardCustomField customField2;
    @JSONField(name="custom_field3")
    private MemCardCustomField customField3;
    @JSONField(name="auto_activate")
    private boolean autoActivate;
    @JSONField(name="init_balance")
    private Integer initBalance;

    public GiftCard(CouponBaseInfo baseInfo, Builder builder) {
        super(baseInfo);
        this.autoActivate = builder.isAutoActivate();
        this.backgroundPicUrl = builder.getBackgroundPicUrl();
        this.customField1 = builder.getCustomField1();
        this.customField2 = builder.getCustomField2();
        this.customField3 = builder.getCustomField3();
        this.supplyBalance = builder.isSupplyBalance();
        this.supplyBonus = builder.isSupplyBonus();
        this.initBalance = builder.getInitBalance();
    }

    @Override
    @JSONField(serialize=false)
    public CardType getCardType() {
        return CardType.GENERAL_COUPON;
    }

    public static final class Builder {
        private String backgroundPicUrl;
        private boolean supplyBonus = false;
        private boolean supplyBalance = false;
        private boolean autoActivate = true;
        private Integer initBalance;
        private MemCardCustomField customField1;
        private MemCardCustomField customField2;
        private MemCardCustomField customField3;

        public String getBackgroundPicUrl() {
            return this.backgroundPicUrl;
        }

        public boolean isSupplyBonus() {
            return this.supplyBonus;
        }

        public boolean isSupplyBalance() {
            return this.supplyBalance;
        }

        public boolean isAutoActivate() {
            return this.autoActivate;
        }

        public Integer getInitBalance() {
            return this.initBalance;
        }

        public MemCardCustomField getCustomField1() {
            return this.customField1;
        }

        public MemCardCustomField getCustomField2() {
            return this.customField2;
        }

        public MemCardCustomField getCustomField3() {
            return this.customField3;
        }

        public Builder backgroundPicUrl(String url) {
            this.backgroundPicUrl = url;
            return this;
        }

        public Builder supplyBonus(boolean supplyBonus) {
            this.supplyBonus = supplyBonus;
            return this;
        }

        public Builder supplyBalance(boolean supplyBalance) {
            this.supplyBalance = supplyBalance;
            return this;
        }

        public Builder autoActivate(boolean autoActivate) {
            this.autoActivate = autoActivate;
            return this;
        }

        public Builder initBalance(Integer initBalance) {
            this.initBalance = initBalance;
            return this;
        }

        public Builder customField1(String name, String url) {
            MemCardCustomField field;
            this.customField1 = field = new MemCardCustomField(name, url, null);
            return this;
        }

        public Builder customField2(String name, String url) {
            MemCardCustomField field;
            this.customField2 = field = new MemCardCustomField(name, url, null);
            return this;
        }

        public Builder customField3(String name, String url) {
            MemCardCustomField field;
            this.customField3 = field = new MemCardCustomField(name, url, null);
            return this;
        }
    }
}

