/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model.card;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.model.card.PageTheme;

public class GiftCardPage {
    @JSONField(name="page_id")
    private String pageId;
    @JSONField(name="page_title")
    private String title;
    @JSONField(name="support_multi")
    private Boolean supportMulti;
    @JSONField(name="support_buy_for_self")
    private Boolean supportBuyForSelf;
    @JSONField(name="banner_pic_url")
    private String bannerPicUrl;
    @JSONField(name="theme_list")
    private JSONArray themeList;
    @JSONField(name="category_list")
    private JSONArray categoryList;
    private String address;
    @JSONField(name="service_phone")
    private String servicePhone;
    @JSONField(name="biz_description")
    private String description;
    @JSONField(name="need_receipt")
    private Boolean needReceipt;
    @JSONField(name="cell_1")
    private JSONObject cell1;
    @JSONField(name="cell_2")
    private JSONObject cell2;

    public String getPageId() {
        return this.pageId;
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getSupportMulti() {
        return this.supportMulti;
    }

    public Boolean getSupportBuyForSelf() {
        return this.supportBuyForSelf;
    }

    public String getBannerPicUrl() {
        return this.bannerPicUrl;
    }

    public JSONArray getThemeList() {
        return this.themeList;
    }

    public JSONArray getCategoryList() {
        return this.categoryList;
    }

    public String getAddress() {
        return this.address;
    }

    public String getServicePhone() {
        return this.servicePhone;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getNeedReceipt() {
        return this.needReceipt;
    }

    public JSONObject getCell1() {
        return this.cell1;
    }

    public JSONObject getCell2() {
        return this.cell2;
    }

    public GiftCardPage(Builder builder) {
        this.pageId = builder.pageId;
        this.address = builder.address;
        this.bannerPicUrl = builder.bannerPicUrl;
        this.categoryList = builder.categoryList;
        this.cell1 = builder.cell1;
        this.cell2 = builder.cell2;
        this.description = builder.description;
        this.needReceipt = builder.needReceipt;
        this.servicePhone = builder.servicePhone;
        this.supportBuyForSelf = builder.supportBuyForSelf;
        this.supportMulti = builder.supportMulti;
        this.themeList = builder.themeList;
        this.title = builder.title;
    }

    public static class Builder {
        private String pageId;
        private String title;
        private Boolean supportMulti;
        private Boolean supportBuyForSelf;
        private String bannerPicUrl;
        private JSONArray themeList = new JSONArray();
        private JSONArray categoryList = null;
        private String address;
        private String servicePhone;
        private String description;
        private Boolean needReceipt;
        private JSONObject cell1;
        private JSONObject cell2;

        public Builder pageId(String pageId) {
            this.pageId = pageId;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder supportMulti(boolean supportMulti) {
            this.supportMulti = supportMulti;
            return this;
        }

        public Builder supportBuyForSelf(boolean supportBuyForSelf) {
            this.supportBuyForSelf = supportBuyForSelf;
            return this;
        }

        public Builder bannerPicUrl(String url) {
            this.bannerPicUrl = url;
            return this;
        }

        public Builder themeList(PageTheme theme) {
            this.themeList.add((Object)theme);
            return this;
        }

        public Builder categoryList(String title) {
            if (this.categoryList == null) {
                this.categoryList = new JSONArray();
            }
            JSONObject category = new JSONObject();
            category.put("title", (Object)title);
            this.categoryList.add((Object)category);
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder servicePhone(String phoneNo) {
            this.servicePhone = phoneNo;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder needReceipt(boolean needReceipt) {
            this.needReceipt = needReceipt;
            return this;
        }

        public Builder cell1(String title, String url) {
            JSONObject cell = new JSONObject();
            cell.put("title", (Object)title);
            cell.put("url", (Object)url);
            this.cell1 = cell;
            return this;
        }

        public Builder cell2(String title, String url) {
            JSONObject cell = new JSONObject();
            cell.put("title", (Object)title);
            cell.put("url", (Object)url);
            this.cell2 = cell;
            return this;
        }
    }
}

