/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model.card;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.model.card.CardItem;
import com.foxinmy.weixin4j.model.card.PicItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PageTheme {
    @JSONField(name="theme_pic_url")
    private String cover;
    private String title;
    @JSONField(name="title_color")
    private String titleColor;
    @JSONField(name="item_list")
    private List<CardItem> itemList;
    @JSONField(name="pic_item_list")
    private List<PicItem> picItemList;
    @JSONField(name="category_index")
    private Integer categoryIndex;
    @JSONField(name="show_sku_title_first")
    private Boolean showSkuTitleFirst;
    @JSONField(name="is_banner")
    private Boolean bannerTheme;

    public PageTheme(Builder builder) {
        this.cover = builder.cover;
        this.title = builder.title;
        this.titleColor = builder.titleColor;
        this.itemList = builder.itemList;
        this.picItemList = builder.picItemList;
        this.categoryIndex = builder.categoryIndex;
        this.showSkuTitleFirst = builder.showSkuTitleFirst;
        this.bannerTheme = builder.bannerTheme;
    }

    public String getCover() {
        return this.cover;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleColor() {
        return this.titleColor;
    }

    public List<CardItem> getItemList() {
        return this.itemList;
    }

    public List<PicItem> getPicItemList() {
        return this.picItemList;
    }

    public Integer getCategoryIndex() {
        return this.categoryIndex;
    }

    public Boolean getShowSkuTitleFirst() {
        return this.showSkuTitleFirst;
    }

    public Boolean getBannerTheme() {
        return this.bannerTheme;
    }

    public static class Builder {
        private String cover;
        private String title;
        private String titleColor;
        private List<CardItem> itemList = new ArrayList<CardItem>();
        private List<PicItem> picItemList = new ArrayList<PicItem>();
        private Integer categoryIndex;
        private Boolean showSkuTitleFirst;
        private Boolean bannerTheme;

        public Builder cover(String cover) {
            this.cover = cover;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder titleColor(String titleColor) {
            this.titleColor = titleColor;
            return this;
        }

        public Builder cardItems(CardItem ... items) {
            this.itemList = Arrays.asList(items);
            return this;
        }

        public Builder addCardItem(CardItem item) {
            this.itemList.add(item);
            return this;
        }

        public Builder picItems(PicItem ... items) {
            this.picItemList = Arrays.asList(items);
            return this;
        }

        public Builder addPicItem(PicItem item) {
            this.picItemList.add(item);
            return this;
        }

        public Builder categoryIndex(Integer index) {
            this.categoryIndex = index;
            return this;
        }

        public Builder showSkuTitleFirst(Boolean isShow) {
            this.showSkuTitleFirst = isShow;
            return this;
        }

        public Builder bannerTheme(Boolean isBanner) {
            this.bannerTheme = isBanner;
            return this;
        }
    }
}

