/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.util.DateUtil;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Deprecated
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PayPackage
extends MerchantResult {
    private static final long serialVersionUID = 3450161267802545790L;
    private String body;
    private String detail;
    @XmlElement(name="out_trade_no")
    @JSONField(name="out_trade_no")
    private String outTradeNo;
    @XmlElement(name="total_fee")
    @JSONField(name="total_fee")
    private int totalFee;
    @XmlElement(name="notify_url")
    @JSONField(name="notify_url")
    private String notifyUrl;
    @XmlElement(name="spbill_create_ip")
    @JSONField(name="spbill_create_ip")
    private String createIp;
    private String attach;
    @XmlElement(name="time_start")
    @JSONField(name="time_start")
    private String timeStart;
    @XmlElement(name="time_expire")
    @JSONField(name="time_expire")
    private String timeExpire;
    @XmlElement(name="goods_tag")
    @JSONField(name="goods_tag")
    private String goodsTag;

    protected PayPackage() {
    }

    public PayPackage(String body, String detail, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach, Date timeStart, Date timeExpire, String goodsTag) {
        this.body = body;
        this.detail = detail;
        this.outTradeNo = outTradeNo;
        this.totalFee = DateUtil.formatYuan2Fen(totalFee);
        this.notifyUrl = notifyUrl;
        this.createIp = createIp;
        this.attach = attach;
        this.timeStart = timeStart != null ? DateUtil.fortmat2yyyyMMddHHmmss(timeStart) : null;
        this.timeExpire = timeExpire != null ? DateUtil.fortmat2yyyyMMddHHmmss(timeExpire) : null;
        this.goodsTag = goodsTag;
    }

    public PayPackage(String body, String detail, String outTradeNo, long totalFee, String notifyUrl, String createIp, String attach, Date timeStart, Date timeExpire, String goodsTag) {
        this.body = body;
        this.detail = detail;
        this.outTradeNo = outTradeNo;
        this.totalFee = Long.valueOf(totalFee).intValue();
        this.notifyUrl = notifyUrl;
        this.createIp = createIp;
        this.attach = attach;
        this.timeStart = timeStart != null ? DateUtil.fortmat2yyyyMMddHHmmss(timeStart) : null;
        this.timeExpire = timeExpire != null ? DateUtil.fortmat2yyyyMMddHHmmss(timeExpire) : null;
        this.goodsTag = goodsTag;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public int getTotalFee() {
        return this.totalFee;
    }

    @JSONField(serialize=false)
    public double getFormatTotalFee() {
        return (double)this.totalFee / 100.0;
    }

    public void setTotalFee(double totalFee) {
        this.totalFee = DateUtil.formatYuan2Fen(totalFee);
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getCreateIp() {
        return this.createIp;
    }

    public void setCreateIp(String createIp) {
        this.createIp = createIp;
    }

    public String getAttach() {
        return this.attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public String getTimeStart() {
        return this.timeStart;
    }

    public void setTimeStart(String timeStart) {
        this.timeStart = timeStart;
    }

    public void setTimeExpire(String timeExpire) {
        this.timeExpire = timeExpire;
    }

    public void setTimeStart(Date timeStart) {
        this.timeStart = timeStart != null ? DateUtil.fortmat2yyyyMMddHHmmss(timeStart) : null;
    }

    public String getTimeExpire() {
        return this.timeExpire;
    }

    public void setTimeExpire(Date timeExpire) {
        this.timeExpire = timeExpire != null ? DateUtil.fortmat2yyyyMMddHHmmss(timeExpire) : null;
    }

    public String getGoodsTag() {
        return this.goodsTag;
    }

    public void setGoodsTag(String goodsTag) {
        this.goodsTag = goodsTag;
    }

    @Override
    public String toString() {
        return "body=" + this.body + ", detail=" + this.detail + ", outTradeNo=" + this.outTradeNo + ", totalFee=" + this.totalFee + ", notifyUrl=" + this.notifyUrl + ", createIp=" + this.createIp + ", attach=" + this.attach + ", timeStart=" + this.timeStart + ", timeExpire=" + this.timeExpire + ", goodsTag=" + this.goodsTag;
    }
}

