/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.util;

import com.foxinmy.weixin4j.util.HexUtil;
import com.foxinmy.weixin4j.util.StringUtil;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class DigestUtil {
    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String SHA1(String content) {
        byte[] data = StringUtil.getBytesUtf8(content);
        return HexUtil.encodeHexString(DigestUtil.getDigest("SHA-1").digest(data));
    }

    public static String SHA(String content) {
        byte[] data = StringUtil.getBytesUtf8(content);
        return HexUtil.encodeHexString(DigestUtil.getDigest("SHA").digest(data));
    }

    public static String MD5(String content) {
        byte[] data = StringUtil.getBytesUtf8(content);
        return HexUtil.encodeHexString(DigestUtil.getDigest("MD5").digest(data));
    }

    public static String HMACSHA256(String content, String key) throws InvalidKeyException {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            mac.init(secret_key);
            byte[] bytes = mac.doFinal(content.getBytes());
            return HexUtil.encodeHexString(bytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

