/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.util;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectId
implements Comparable<ObjectId>,
Serializable {
    private static final long serialVersionUID = -4415279469780082174L;
    static final Logger LOGGER = Logger.getLogger("org.bson.ObjectId");
    final int _time;
    final int _machine;
    final int _inc;
    boolean _new;
    private static AtomicInteger _nextInc = new AtomicInteger(new Random().nextInt());
    private static final int _genmachine;

    public static ObjectId get() {
        return new ObjectId();
    }

    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        int len = s.length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public ObjectId(byte[] b) {
        if (b.length != 12) {
            throw new IllegalArgumentException("need 12 bytes");
        }
        ByteBuffer bb = ByteBuffer.wrap(b);
        this._time = bb.getInt();
        this._machine = bb.getInt();
        this._inc = bb.getInt();
        this._new = false;
    }

    public ObjectId() {
        this._time = (int)(System.currentTimeMillis() / 1000L);
        this._machine = _genmachine;
        this._inc = _nextInc.getAndIncrement();
        this._new = true;
    }

    public int hashCode() {
        int x = this._time;
        x += this._machine * 111;
        return x += this._inc * 17;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectId)) {
            return false;
        }
        ObjectId other = (ObjectId)o;
        return this._time == other._time && this._machine == other._machine && this._inc == other._inc;
    }

    public String toHexString() {
        StringBuilder buf = new StringBuilder(24);
        for (byte b : this.toByteArray()) {
            buf.append(String.format("%02x", b & 0xFF));
        }
        return buf.toString();
    }

    public byte[] toByteArray() {
        byte[] b = new byte[12];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(this._time);
        bb.putInt(this._machine);
        bb.putInt(this._inc);
        return b;
    }

    static String _pos(String s, int p) {
        return s.substring(p * 2, p * 2 + 2);
    }

    public String toString() {
        byte[] b = this.toByteArray();
        StringBuilder buf = new StringBuilder(24);
        for (int i = 0; i < b.length; ++i) {
            int x = b[i] & 0xFF;
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    int _compareUnsigned(int i, int j) {
        long li = 0xFFFFFFFFL;
        li = (long)i & li;
        long lj = 0xFFFFFFFFL;
        long diff = li - (lj = (long)j & lj);
        if (diff < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (diff > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)diff;
    }

    @Override
    public int compareTo(ObjectId id) {
        if (id == null) {
            return -1;
        }
        int x = this._compareUnsigned(this._time, id._time);
        if (x != 0) {
            return x;
        }
        x = this._compareUnsigned(this._machine, id._machine);
        if (x != 0) {
            return x;
        }
        return this._compareUnsigned(this._inc, id._inc);
    }

    public int getTimestamp() {
        return this._time;
    }

    public Date getDate() {
        return new Date((long)this._time * 1000L);
    }

    public static int getCurrentCounter() {
        return _nextInc.get();
    }

    static {
        try {
            int machinePiece;
            try {
                StringBuilder sb = new StringBuilder();
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    sb.append(ni.toString());
                }
                machinePiece = sb.toString().hashCode() << 16;
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                machinePiece = new Random().nextInt() << 16;
            }
            LOGGER.fine("machine piece post: " + Integer.toHexString(machinePiece));
            int processId = new Random().nextInt();
            try {
                processId = ManagementFactory.getRuntimeMXBean().getName().hashCode();
            }
            catch (Throwable ni) {
                // empty catch block
            }
            ClassLoader loader = ObjectId.class.getClassLoader();
            int loaderId = loader != null ? System.identityHashCode(loader) : 0;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toHexString(processId));
            sb.append(Integer.toHexString(loaderId));
            int processPiece = sb.toString().hashCode() & 0xFFFF;
            LOGGER.fine("process piece: " + Integer.toHexString(processPiece));
            _genmachine = machinePiece | processPiece;
            LOGGER.fine("machine : " + Integer.toHexString(_genmachine));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

