/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class SettableFuture<T>
implements Future<T> {
    private final SettableTask<T> settableTask = new SettableTask();
    private final FutureTask<T> futureTask = new FutureTask<T>(this.settableTask);

    public boolean set(T value) {
        boolean success = this.settableTask.setValue(value);
        if (success) {
            this.futureTask.run();
        }
        return success;
    }

    public boolean setException(Throwable exception) {
        boolean success = this.settableTask.setException(exception);
        if (success) {
            this.futureTask.run();
        }
        return success;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.settableTask.setCancelled();
        boolean cancelled = this.futureTask.cancel(mayInterruptIfRunning);
        if (cancelled && mayInterruptIfRunning) {
            this.interruptTask();
        }
        return cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.futureTask.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.futureTask.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.futureTask.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.futureTask.get(timeout, unit);
    }

    protected void interruptTask() {
    }

    private static class SettableTask<T>
    implements Callable<T> {
        private static final String NO_VALUE = SettableFuture.class.getName() + ".NO_VALUE";
        private final AtomicReference<Object> value = new AtomicReference<String>(NO_VALUE);
        private volatile boolean cancelled = false;

        private SettableTask() {
        }

        public boolean setValue(T value) {
            if (this.cancelled) {
                return false;
            }
            return this.value.compareAndSet(NO_VALUE, value);
        }

        public boolean setException(Throwable exception) {
            if (this.cancelled) {
                return false;
            }
            return this.value.compareAndSet(NO_VALUE, exception);
        }

        public void setCancelled() {
            this.cancelled = true;
        }

        @Override
        public T call() throws Exception {
            if (this.value.get() instanceof Exception) {
                throw (Exception)this.value.get();
            }
            return (T)this.value.get();
        }
    }
}

