/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.xml;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class XmlStream {
    private static final String ROOT_ELEMENT_XML = "xml";
    private static final String XML_VERSION = "1.0";
    private static final ConcurrentHashMap<Class<?>, JAXBContext> jaxbContexts = new ConcurrentHashMap();
    private static final SAXParserFactory spf = SAXParserFactory.newInstance();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromXML(InputStream content, Class<T> clazz) {
        JAXBContext jaxbContext = XmlStream.getJaxbContext(clazz);
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            XMLReader reader = spf.newSAXParser().getXMLReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXSource source = new SAXSource(reader, new InputSource(content));
            XmlRootElement rootElement = clazz.getAnnotation(XmlRootElement.class);
            if (rootElement == null || rootElement.name().equals(XmlRootElement.class.getMethod("name", new Class[0]).getDefaultValue().toString())) {
                JAXBElement jaxbElement = unmarshaller.unmarshal((Source)source, clazz);
                Object object = jaxbElement.getValue();
                return (T)object;
            }
            Object object = unmarshaller.unmarshal((Source)source);
            return (T)object;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not unmarshaller class [" + clazz + "]", ex);
        }
        finally {
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static <T> T fromXML(String content, Class<T> clazz) {
        return XmlStream.fromXML(new ByteArrayInputStream(content.getBytes(Consts.UTF_8)), clazz);
    }

    public static String map2xml(Map<String, String> map) {
        StringWriter sw = new StringWriter();
        try {
            XMLStreamWriter xw = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
            xw.writeStartDocument(Consts.UTF_8.name(), XML_VERSION);
            xw.writeStartElement(ROOT_ELEMENT_XML);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (StringUtil.isBlank(entry.getValue())) continue;
                xw.writeStartElement(entry.getKey());
                xw.writeCData(entry.getValue());
                xw.writeEndElement();
            }
            xw.writeEndDocument();
            xw.flush();
            xw.close();
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException iOException) {}
        }
        return sw.getBuffer().toString();
    }

    public static String map2xml(JSONObject json) {
        StringWriter sw = new StringWriter();
        try {
            XMLStreamWriter xw = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
            xw.writeStartDocument(Consts.UTF_8.name(), XML_VERSION);
            xw.writeStartElement(ROOT_ELEMENT_XML);
            for (Map.Entry entry : json.entrySet()) {
                if (StringUtil.isBlank(json.getString((String)entry.getKey()))) continue;
                xw.writeStartElement((String)entry.getKey());
                xw.writeCData(json.getString((String)entry.getKey()));
                xw.writeEndElement();
            }
            xw.writeEndDocument();
            xw.flush();
            xw.close();
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException iOException) {}
        }
        return sw.getBuffer().toString();
    }

    /*
     * Unable to fully structure code
     */
    public static Map<String, String> xml2map(String content) {
        map = new HashMap<String, String>();
        sr = new StringReader(content);
        try {
            xr = XMLInputFactory.newInstance().createXMLStreamReader(sr);
            block5: while (true) {
                if ((event = xr.next()) == 8) {
                    xr.close();
                    break;
                }
                if (event != 1) continue;
                name = xr.getLocalName();
                while (true) {
                    if ((event = xr.next()) == 1) {
                        name = xr.getLocalName();
                        continue;
                    }
                    if (event != 2) ** break;
                    continue block5;
                    if (event != 4) continue;
                    value = xr.getText();
                    map.put(name, value);
                }
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            sr.close();
        }
        return map;
    }

    public static String toXML(Object object) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XmlStream.toXML(object, os);
        return StringUtil.newStringUtf8(os.toByteArray());
    }

    public static <T> void toXML(T t, OutputStream os) {
        Class<?> clazz = t.getClass();
        JAXBContext jaxbContext = XmlStream.getJaxbContext(clazz);
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)Consts.UTF_8.name());
            XmlRootElement rootElement = clazz.getAnnotation(XmlRootElement.class);
            if (rootElement == null || rootElement.name().equals(XmlRootElement.class.getMethod("name", new Class[0]).getDefaultValue().toString())) {
                marshaller.marshal((Object)new JAXBElement(new QName(ROOT_ELEMENT_XML), clazz, t), os);
            } else {
                marshaller.marshal(t, os);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not marshal class [" + clazz + "] ", ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static JAXBContext getJaxbContext(Class<?> clazz) {
        JAXBContext jaxbContext = jaxbContexts.get(clazz);
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                jaxbContexts.putIfAbsent(clazz, jaxbContext);
            }
            catch (JAXBException ex) {
                throw new RuntimeException("Could not instantiate JAXBContext for class [" + clazz + "] ", ex);
            }
        }
        return jaxbContext;
    }

    static {
        try {
            spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            spf.setXIncludeAware(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

