/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.message;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import me.chanjar.weixin.cp.bean.outxmlbuilder.EventBuilder;
import me.chanjar.weixin.cp.bean.outxmlbuilder.ImageBuilder;
import me.chanjar.weixin.cp.bean.outxmlbuilder.NewsBuilder;
import me.chanjar.weixin.cp.bean.outxmlbuilder.TaskCardBuilder;
import me.chanjar.weixin.cp.bean.outxmlbuilder.TextBuilder;
import me.chanjar.weixin.cp.bean.outxmlbuilder.UpdateButtonBuilder;
import me.chanjar.weixin.cp.bean.outxmlbuilder.VideoBuilder;
import me.chanjar.weixin.cp.bean.outxmlbuilder.VoiceBuilder;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.WxCpTpConfigStorage;
import me.chanjar.weixin.cp.util.crypto.WxCpCryptUtil;
import me.chanjar.weixin.cp.util.crypto.WxCpTpCryptUtil;
import me.chanjar.weixin.cp.util.xml.XStreamTransformer;

@XStreamAlias(value="xml")
public abstract class WxCpXmlOutMessage
implements Serializable {
    private static final long serialVersionUID = 1418629839964153110L;
    @XStreamAlias(value="ToUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    protected String toUserName;
    @XStreamAlias(value="FromUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    protected String fromUserName;
    @XStreamAlias(value="CreateTime")
    protected Long createTime;
    @XStreamAlias(value="MsgType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    protected String msgType;

    public static TextBuilder TEXT() {
        return new TextBuilder();
    }

    public static ImageBuilder IMAGE() {
        return new ImageBuilder();
    }

    public static VoiceBuilder VOICE() {
        return new VoiceBuilder();
    }

    public static VideoBuilder VIDEO() {
        return new VideoBuilder();
    }

    public static NewsBuilder NEWS() {
        return new NewsBuilder();
    }

    public static TaskCardBuilder TASK_CARD() {
        return new TaskCardBuilder();
    }

    public static UpdateButtonBuilder UPDATE_BUTTON() {
        return new UpdateButtonBuilder();
    }

    public static EventBuilder EVENT() {
        return new EventBuilder();
    }

    protected String toXml() {
        return XStreamTransformer.toXml(this.getClass(), this);
    }

    public String toEncryptedXml(WxCpConfigStorage wxCpConfigStorage) {
        String plainXml = this.toXml();
        WxCpCryptUtil pc = new WxCpCryptUtil(wxCpConfigStorage);
        return pc.encrypt(plainXml);
    }

    public String toEncryptedXml(WxCpTpConfigStorage wxCpTpConfigStorage) {
        String plainXml = this.toXml();
        WxCpTpCryptUtil pc = new WxCpTpCryptUtil(wxCpTpConfigStorage);
        return pc.encrypt(plainXml);
    }

    public String getToUserName() {
        return this.toUserName;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpXmlOutMessage)) {
            return false;
        }
        WxCpXmlOutMessage other = (WxCpXmlOutMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$toUserName = this.getToUserName();
        String other$toUserName = other.getToUserName();
        if (this$toUserName == null ? other$toUserName != null : !this$toUserName.equals(other$toUserName)) {
            return false;
        }
        String this$fromUserName = this.getFromUserName();
        String other$fromUserName = other.getFromUserName();
        if (this$fromUserName == null ? other$fromUserName != null : !this$fromUserName.equals(other$fromUserName)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        return !(this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpXmlOutMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $toUserName = this.getToUserName();
        result = result * 59 + ($toUserName == null ? 43 : $toUserName.hashCode());
        String $fromUserName = this.getFromUserName();
        result = result * 59 + ($fromUserName == null ? 43 : $fromUserName.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        return result;
    }

    public String toString() {
        return "WxCpXmlOutMessage(toUserName=" + this.getToUserName() + ", fromUserName=" + this.getFromUserName() + ", createTime=" + this.getCreateTime() + ", msgType=" + this.getMsgType() + ")";
    }
}

