/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaShopDeliveryService;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopDeliveryRecieveRequest;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopDeliverySendRequest;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopBaseResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopDeliveryGetCompanyListResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaShopDeliveryServiceImpl
implements WxMaShopDeliveryService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShopDeliveryServiceImpl.class);
    private final WxMaService wxMaService;

    @Override
    public WxMaShopDeliveryGetCompanyListResponse getCompanyList() throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/delivery/get_company_list", new JsonObject());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopDeliveryGetCompanyListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopDeliveryGetCompanyListResponse.class);
    }

    @Override
    public WxMaShopBaseResponse send(WxMaShopDeliverySendRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/delivery/send", request);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopBaseResponse receive(WxMaShopDeliveryRecieveRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/delivery/recieve", request);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    public WxMaShopDeliveryServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

