/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.config;

import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.v3.WxPayV3HttpClientBuilder;
import com.github.binarywang.wxpay.v3.auth.AutoUpdateCertificatesVerifier;
import com.github.binarywang.wxpay.v3.auth.PrivateKeySigner;
import com.github.binarywang.wxpay.v3.auth.Verifier;
import com.github.binarywang.wxpay.v3.auth.WxPayCredentials;
import com.github.binarywang.wxpay.v3.auth.WxPayValidator;
import com.github.binarywang.wxpay.v3.util.PemUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import jodd.util.ResourcesUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.ssl.SSLContexts;

public class WxPayConfig {
    private static final String DEFAULT_PAY_BASE_URL = "https://api.mch.weixin.qq.com";
    private static final String PROBLEM_MSG = "\u8bc1\u4e66\u6587\u4ef6\u3010%s\u3011\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01";
    private static final String NOT_FOUND_MSG = "\u8bc1\u4e66\u6587\u4ef6\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01";
    private String payBaseUrl = "https://api.mch.weixin.qq.com";
    private int httpConnectionTimeout = 5000;
    private int httpTimeout = 10000;
    private String appId;
    private String subAppId;
    private String mchId;
    private String mchKey;
    private String entPayKey;
    private String subMchId;
    private String notifyUrl;
    private String tradeType;
    private String signType;
    private SSLContext sslContext;
    private String keyPath;
    private String privateKeyPath;
    private String privateCertPath;
    private String apiV3Key;
    private String certSerialNo;
    private String serviceId;
    private String payScoreNotifyUrl;
    private CloseableHttpClient apiV3HttpClient;
    private PrivateKey privateKey;
    private int certAutoUpdateTime = 60;
    private byte[] keyContent;
    private boolean useSandboxEnv = false;
    private boolean ifSaveApiData = false;
    private String httpProxyHost;
    private Integer httpProxyPort;
    private String httpProxyUsername;
    private String httpProxyPassword;
    private Verifier verifier;

    public String getPayBaseUrl() {
        if (StringUtils.isEmpty((CharSequence)this.payBaseUrl)) {
            return DEFAULT_PAY_BASE_URL;
        }
        return this.payBaseUrl;
    }

    public Verifier getVerifier() {
        if (this.verifier == null) {
            this.initApiV3HttpClient();
        }
        return this.verifier;
    }

    public SSLContext initSSLContext() throws WxPayException {
        InputStream inputStream;
        if (StringUtils.isBlank((CharSequence)this.getMchId())) {
            throw new WxPayException("\u8bf7\u786e\u4fdd\u5546\u6237\u53f7mchId\u5df2\u8bbe\u7f6e");
        }
        if (this.keyContent != null) {
            inputStream = new ByteArrayInputStream(this.keyContent);
        } else {
            if (StringUtils.isBlank((CharSequence)this.getKeyPath())) {
                throw new WxPayException("\u8bf7\u786e\u4fdd\u8bc1\u4e66\u6587\u4ef6\u5730\u5740keyPath\u5df2\u914d\u7f6e");
            }
            inputStream = this.loadConfigInputStream(this.getKeyPath());
        }
        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            char[] partnerId2charArray = this.getMchId().toCharArray();
            keystore.load(inputStream, partnerId2charArray);
            SSLContext sSLContext = this.sslContext = SSLContexts.custom().loadKeyMaterial(keystore, partnerId2charArray).build();
            return sSLContext;
        }
        catch (Exception e) {
            throw new WxPayException("\u8bc1\u4e66\u6587\u4ef6\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public CloseableHttpClient initApiV3HttpClient() throws WxPayException {
        String privateKeyPath = this.getPrivateKeyPath();
        String privateCertPath = this.getPrivateCertPath();
        String certSerialNo = this.getCertSerialNo();
        String apiV3Key = this.getApiV3Key();
        if (StringUtils.isBlank((CharSequence)privateKeyPath)) {
            throw new WxPayException("\u8bf7\u786e\u4fddprivateKeyPath\u5df2\u8bbe\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)privateCertPath)) {
            throw new WxPayException("\u8bf7\u786e\u4fddprivateCertPath\u5df2\u8bbe\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)certSerialNo)) {
            throw new WxPayException("\u8bf7\u786e\u4fddcertSerialNo\u8bc1\u4e66\u5e8f\u5217\u53f7\u5df2\u8bbe\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)apiV3Key)) {
            throw new WxPayException("\u8bf7\u786e\u4fddapiV3Key\u503c\u5df2\u8bbe\u7f6e");
        }
        InputStream keyInputStream = this.loadConfigInputStream(privateKeyPath);
        InputStream certInputStream = this.loadConfigInputStream(privateCertPath);
        try {
            CloseableHttpClient httpClient;
            PrivateKey merchantPrivateKey = PemUtils.loadPrivateKey(keyInputStream);
            AutoUpdateCertificatesVerifier verifier = new AutoUpdateCertificatesVerifier(new WxPayCredentials(this.mchId, new PrivateKeySigner(certSerialNo, merchantPrivateKey)), apiV3Key.getBytes(StandardCharsets.UTF_8), this.getCertAutoUpdateTime());
            this.apiV3HttpClient = httpClient = WxPayV3HttpClientBuilder.create().withMerchant(this.mchId, certSerialNo, merchantPrivateKey).withWechatpay(Collections.singletonList(PemUtils.loadCertificate(certInputStream))).withValidator(new WxPayValidator(verifier)).build();
            this.verifier = verifier;
            this.privateKey = merchantPrivateKey;
            return httpClient;
        }
        catch (Exception e) {
            throw new WxPayException("v3\u8bf7\u6c42\u6784\u9020\u5f02\u5e38\uff01", e);
        }
    }

    private InputStream loadConfigInputStream(String configPath) throws WxPayException {
        InputStream inputStream;
        block12: {
            String prefix = "classpath:";
            String fileHasProblemMsg = String.format(PROBLEM_MSG, configPath);
            String fileNotFoundMsg = String.format(NOT_FOUND_MSG, configPath);
            if (configPath.startsWith("classpath:")) {
                String path = RegExUtils.removeFirst((String)configPath, (String)"classpath:");
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                try {
                    inputStream = ResourcesUtil.getResourceAsStream((String)path);
                    if (inputStream == null) {
                        throw new WxPayException(fileNotFoundMsg);
                    }
                    break block12;
                }
                catch (Exception e) {
                    throw new WxPayException(fileNotFoundMsg, e);
                }
            }
            if (configPath.startsWith("http://") || configPath.startsWith("https://")) {
                try {
                    inputStream = new URL(configPath).openStream();
                    if (inputStream == null) {
                        throw new WxPayException(fileNotFoundMsg);
                    }
                    break block12;
                }
                catch (IOException e) {
                    throw new WxPayException(fileNotFoundMsg, e);
                }
            }
            try {
                File file = new File(configPath);
                if (!file.exists()) {
                    throw new WxPayException(fileNotFoundMsg);
                }
                inputStream = new FileInputStream(file);
            }
            catch (IOException e) {
                throw new WxPayException(fileHasProblemMsg, e);
            }
        }
        return inputStream;
    }

    public int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public int getHttpTimeout() {
        return this.httpTimeout;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getMchKey() {
        return this.mchKey;
    }

    public String getEntPayKey() {
        return this.entPayKey;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public String getSignType() {
        return this.signType;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public String getPrivateCertPath() {
        return this.privateCertPath;
    }

    public String getApiV3Key() {
        return this.apiV3Key;
    }

    public String getCertSerialNo() {
        return this.certSerialNo;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getPayScoreNotifyUrl() {
        return this.payScoreNotifyUrl;
    }

    public CloseableHttpClient getApiV3HttpClient() {
        return this.apiV3HttpClient;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public int getCertAutoUpdateTime() {
        return this.certAutoUpdateTime;
    }

    public byte[] getKeyContent() {
        return this.keyContent;
    }

    public boolean isUseSandboxEnv() {
        return this.useSandboxEnv;
    }

    public boolean isIfSaveApiData() {
        return this.ifSaveApiData;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setPayBaseUrl(String payBaseUrl) {
        this.payBaseUrl = payBaseUrl;
    }

    public void setHttpConnectionTimeout(int httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
    }

    public void setHttpTimeout(int httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setSubAppId(String subAppId) {
        this.subAppId = subAppId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setMchKey(String mchKey) {
        this.mchKey = mchKey;
    }

    public void setEntPayKey(String entPayKey) {
        this.entPayKey = entPayKey;
    }

    public void setSubMchId(String subMchId) {
        this.subMchId = subMchId;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public void setPrivateCertPath(String privateCertPath) {
        this.privateCertPath = privateCertPath;
    }

    public void setApiV3Key(String apiV3Key) {
        this.apiV3Key = apiV3Key;
    }

    public void setCertSerialNo(String certSerialNo) {
        this.certSerialNo = certSerialNo;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setPayScoreNotifyUrl(String payScoreNotifyUrl) {
        this.payScoreNotifyUrl = payScoreNotifyUrl;
    }

    public void setApiV3HttpClient(CloseableHttpClient apiV3HttpClient) {
        this.apiV3HttpClient = apiV3HttpClient;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setCertAutoUpdateTime(int certAutoUpdateTime) {
        this.certAutoUpdateTime = certAutoUpdateTime;
    }

    public void setKeyContent(byte[] keyContent) {
        this.keyContent = keyContent;
    }

    public void setUseSandboxEnv(boolean useSandboxEnv) {
        this.useSandboxEnv = useSandboxEnv;
    }

    public void setIfSaveApiData(boolean ifSaveApiData) {
        this.ifSaveApiData = ifSaveApiData;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public void setVerifier(Verifier verifier) {
        this.verifier = verifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayConfig)) {
            return false;
        }
        WxPayConfig other = (WxPayConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$payBaseUrl = this.getPayBaseUrl();
        String other$payBaseUrl = other.getPayBaseUrl();
        if (this$payBaseUrl == null ? other$payBaseUrl != null : !this$payBaseUrl.equals(other$payBaseUrl)) {
            return false;
        }
        if (this.getHttpConnectionTimeout() != other.getHttpConnectionTimeout()) {
            return false;
        }
        if (this.getHttpTimeout() != other.getHttpTimeout()) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$subAppId = this.getSubAppId();
        String other$subAppId = other.getSubAppId();
        if (this$subAppId == null ? other$subAppId != null : !this$subAppId.equals(other$subAppId)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$mchKey = this.getMchKey();
        String other$mchKey = other.getMchKey();
        if (this$mchKey == null ? other$mchKey != null : !this$mchKey.equals(other$mchKey)) {
            return false;
        }
        String this$entPayKey = this.getEntPayKey();
        String other$entPayKey = other.getEntPayKey();
        if (this$entPayKey == null ? other$entPayKey != null : !this$entPayKey.equals(other$entPayKey)) {
            return false;
        }
        String this$subMchId = this.getSubMchId();
        String other$subMchId = other.getSubMchId();
        if (this$subMchId == null ? other$subMchId != null : !this$subMchId.equals(other$subMchId)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$tradeType = this.getTradeType();
        String other$tradeType = other.getTradeType();
        if (this$tradeType == null ? other$tradeType != null : !this$tradeType.equals(other$tradeType)) {
            return false;
        }
        String this$signType = this.getSignType();
        String other$signType = other.getSignType();
        if (this$signType == null ? other$signType != null : !this$signType.equals(other$signType)) {
            return false;
        }
        SSLContext this$sslContext = this.getSslContext();
        SSLContext other$sslContext = other.getSslContext();
        if (this$sslContext == null ? other$sslContext != null : !this$sslContext.equals(other$sslContext)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$privateKeyPath = this.getPrivateKeyPath();
        String other$privateKeyPath = other.getPrivateKeyPath();
        if (this$privateKeyPath == null ? other$privateKeyPath != null : !this$privateKeyPath.equals(other$privateKeyPath)) {
            return false;
        }
        String this$privateCertPath = this.getPrivateCertPath();
        String other$privateCertPath = other.getPrivateCertPath();
        if (this$privateCertPath == null ? other$privateCertPath != null : !this$privateCertPath.equals(other$privateCertPath)) {
            return false;
        }
        String this$apiV3Key = this.getApiV3Key();
        String other$apiV3Key = other.getApiV3Key();
        if (this$apiV3Key == null ? other$apiV3Key != null : !this$apiV3Key.equals(other$apiV3Key)) {
            return false;
        }
        String this$certSerialNo = this.getCertSerialNo();
        String other$certSerialNo = other.getCertSerialNo();
        if (this$certSerialNo == null ? other$certSerialNo != null : !this$certSerialNo.equals(other$certSerialNo)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$payScoreNotifyUrl = this.getPayScoreNotifyUrl();
        String other$payScoreNotifyUrl = other.getPayScoreNotifyUrl();
        if (this$payScoreNotifyUrl == null ? other$payScoreNotifyUrl != null : !this$payScoreNotifyUrl.equals(other$payScoreNotifyUrl)) {
            return false;
        }
        CloseableHttpClient this$apiV3HttpClient = this.getApiV3HttpClient();
        CloseableHttpClient other$apiV3HttpClient = other.getApiV3HttpClient();
        if (this$apiV3HttpClient == null ? other$apiV3HttpClient != null : !this$apiV3HttpClient.equals(other$apiV3HttpClient)) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        if (this.getCertAutoUpdateTime() != other.getCertAutoUpdateTime()) {
            return false;
        }
        if (!Arrays.equals(this.getKeyContent(), other.getKeyContent())) {
            return false;
        }
        if (this.isUseSandboxEnv() != other.isUseSandboxEnv()) {
            return false;
        }
        if (this.isIfSaveApiData() != other.isIfSaveApiData()) {
            return false;
        }
        String this$httpProxyHost = this.getHttpProxyHost();
        String other$httpProxyHost = other.getHttpProxyHost();
        if (this$httpProxyHost == null ? other$httpProxyHost != null : !this$httpProxyHost.equals(other$httpProxyHost)) {
            return false;
        }
        Integer this$httpProxyPort = this.getHttpProxyPort();
        Integer other$httpProxyPort = other.getHttpProxyPort();
        if (this$httpProxyPort == null ? other$httpProxyPort != null : !((Object)this$httpProxyPort).equals(other$httpProxyPort)) {
            return false;
        }
        String this$httpProxyUsername = this.getHttpProxyUsername();
        String other$httpProxyUsername = other.getHttpProxyUsername();
        if (this$httpProxyUsername == null ? other$httpProxyUsername != null : !this$httpProxyUsername.equals(other$httpProxyUsername)) {
            return false;
        }
        String this$httpProxyPassword = this.getHttpProxyPassword();
        String other$httpProxyPassword = other.getHttpProxyPassword();
        if (this$httpProxyPassword == null ? other$httpProxyPassword != null : !this$httpProxyPassword.equals(other$httpProxyPassword)) {
            return false;
        }
        Verifier this$verifier = this.getVerifier();
        Verifier other$verifier = other.getVerifier();
        return !(this$verifier == null ? other$verifier != null : !this$verifier.equals(other$verifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxPayConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $payBaseUrl = this.getPayBaseUrl();
        result = result * 59 + ($payBaseUrl == null ? 43 : $payBaseUrl.hashCode());
        result = result * 59 + this.getHttpConnectionTimeout();
        result = result * 59 + this.getHttpTimeout();
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $subAppId = this.getSubAppId();
        result = result * 59 + ($subAppId == null ? 43 : $subAppId.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $mchKey = this.getMchKey();
        result = result * 59 + ($mchKey == null ? 43 : $mchKey.hashCode());
        String $entPayKey = this.getEntPayKey();
        result = result * 59 + ($entPayKey == null ? 43 : $entPayKey.hashCode());
        String $subMchId = this.getSubMchId();
        result = result * 59 + ($subMchId == null ? 43 : $subMchId.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $tradeType = this.getTradeType();
        result = result * 59 + ($tradeType == null ? 43 : $tradeType.hashCode());
        String $signType = this.getSignType();
        result = result * 59 + ($signType == null ? 43 : $signType.hashCode());
        SSLContext $sslContext = this.getSslContext();
        result = result * 59 + ($sslContext == null ? 43 : $sslContext.hashCode());
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $privateKeyPath = this.getPrivateKeyPath();
        result = result * 59 + ($privateKeyPath == null ? 43 : $privateKeyPath.hashCode());
        String $privateCertPath = this.getPrivateCertPath();
        result = result * 59 + ($privateCertPath == null ? 43 : $privateCertPath.hashCode());
        String $apiV3Key = this.getApiV3Key();
        result = result * 59 + ($apiV3Key == null ? 43 : $apiV3Key.hashCode());
        String $certSerialNo = this.getCertSerialNo();
        result = result * 59 + ($certSerialNo == null ? 43 : $certSerialNo.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $payScoreNotifyUrl = this.getPayScoreNotifyUrl();
        result = result * 59 + ($payScoreNotifyUrl == null ? 43 : $payScoreNotifyUrl.hashCode());
        CloseableHttpClient $apiV3HttpClient = this.getApiV3HttpClient();
        result = result * 59 + ($apiV3HttpClient == null ? 43 : $apiV3HttpClient.hashCode());
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        result = result * 59 + this.getCertAutoUpdateTime();
        result = result * 59 + Arrays.hashCode(this.getKeyContent());
        result = result * 59 + (this.isUseSandboxEnv() ? 79 : 97);
        result = result * 59 + (this.isIfSaveApiData() ? 79 : 97);
        String $httpProxyHost = this.getHttpProxyHost();
        result = result * 59 + ($httpProxyHost == null ? 43 : $httpProxyHost.hashCode());
        Integer $httpProxyPort = this.getHttpProxyPort();
        result = result * 59 + ($httpProxyPort == null ? 43 : ((Object)$httpProxyPort).hashCode());
        String $httpProxyUsername = this.getHttpProxyUsername();
        result = result * 59 + ($httpProxyUsername == null ? 43 : $httpProxyUsername.hashCode());
        String $httpProxyPassword = this.getHttpProxyPassword();
        result = result * 59 + ($httpProxyPassword == null ? 43 : $httpProxyPassword.hashCode());
        Verifier $verifier = this.getVerifier();
        result = result * 59 + ($verifier == null ? 43 : $verifier.hashCode());
        return result;
    }

    public String toString() {
        return "WxPayConfig(payBaseUrl=" + this.getPayBaseUrl() + ", httpConnectionTimeout=" + this.getHttpConnectionTimeout() + ", httpTimeout=" + this.getHttpTimeout() + ", appId=" + this.getAppId() + ", subAppId=" + this.getSubAppId() + ", mchId=" + this.getMchId() + ", mchKey=" + this.getMchKey() + ", entPayKey=" + this.getEntPayKey() + ", subMchId=" + this.getSubMchId() + ", notifyUrl=" + this.getNotifyUrl() + ", tradeType=" + this.getTradeType() + ", signType=" + this.getSignType() + ", sslContext=" + this.getSslContext() + ", keyPath=" + this.getKeyPath() + ", privateKeyPath=" + this.getPrivateKeyPath() + ", privateCertPath=" + this.getPrivateCertPath() + ", apiV3Key=" + this.getApiV3Key() + ", certSerialNo=" + this.getCertSerialNo() + ", serviceId=" + this.getServiceId() + ", payScoreNotifyUrl=" + this.getPayScoreNotifyUrl() + ", apiV3HttpClient=" + this.getApiV3HttpClient() + ", privateKey=" + this.getPrivateKey() + ", certAutoUpdateTime=" + this.getCertAutoUpdateTime() + ", keyContent=" + Arrays.toString(this.getKeyContent()) + ", useSandboxEnv=" + this.isUseSandboxEnv() + ", ifSaveApiData=" + this.isIfSaveApiData() + ", httpProxyHost=" + this.getHttpProxyHost() + ", httpProxyPort=" + this.getHttpProxyPort() + ", httpProxyUsername=" + this.getHttpProxyUsername() + ", httpProxyPassword=" + this.getHttpProxyPassword() + ", verifier=" + this.getVerifier() + ")";
    }
}

