/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.applyment.ApplymentStateQueryResult;
import com.github.binarywang.wxpay.bean.applyment.ModifySettlementRequest;
import com.github.binarywang.wxpay.bean.applyment.SettlementInfoResult;
import com.github.binarywang.wxpay.bean.applyment.WxPayApplyment4SubCreateRequest;
import com.github.binarywang.wxpay.bean.applyment.WxPayApplymentCreateResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.Applyment4SubService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URI;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Applyment4SubServiceImpl
implements Applyment4SubService {
    private static final Logger log = LoggerFactory.getLogger(Applyment4SubServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    private void encryptFiled(Object request) throws WxPayException {
        X509Certificate validCertificate = this.payService.getConfig().getVerifier().getValidCertificate();
        RsaCryptoUtil.encryptFields(request, validCertificate);
    }

    @Override
    public WxPayApplymentCreateResult createApply(WxPayApplyment4SubCreateRequest request) throws WxPayException {
        String url = String.format("%s/v3/applyment4sub/applyment/", this.payService.getPayBaseUrl());
        this.encryptFiled(request);
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (WxPayApplymentCreateResult)GSON.fromJson(result, WxPayApplymentCreateResult.class);
    }

    @Override
    public ApplymentStateQueryResult queryApplyStatusByBusinessCode(String businessCode) throws WxPayException {
        String url = String.format("%s/v3/applyment4sub/applyment/business_code/%s", this.payService.getPayBaseUrl(), businessCode);
        String result = this.payService.getV3(URI.create(url));
        return (ApplymentStateQueryResult)GSON.fromJson(result, ApplymentStateQueryResult.class);
    }

    @Override
    public ApplymentStateQueryResult queryApplyStatusByApplymentId(String applymentId) throws WxPayException {
        String url = String.format("%s/v3/applyment4sub/applyment/applyment_id/%s", this.payService.getPayBaseUrl(), applymentId);
        String result = this.payService.getV3(URI.create(url));
        return (ApplymentStateQueryResult)GSON.fromJson(result, ApplymentStateQueryResult.class);
    }

    @Override
    public SettlementInfoResult querySettlementBySubMchid(String subMchid) throws WxPayException {
        String url = String.format("%s/v3/apply4sub/sub_merchants/%s/settlement", this.payService.getPayBaseUrl(), subMchid);
        String result = this.payService.getV3(URI.create(url));
        return (SettlementInfoResult)GSON.fromJson(result, SettlementInfoResult.class);
    }

    @Override
    public void modifySettlement(String subMchid, ModifySettlementRequest request) throws WxPayException {
        String url = String.format("%s/v3/apply4sub/sub_merchants/%s/modify-settlement", this.payService.getPayBaseUrl(), subMchid);
        this.encryptFiled(request);
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
    }

    public Applyment4SubServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

