/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.miniapp.config.storage;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaRedisBetterConfigImpl;
import com.binarywang.spring.starter.wxjava.miniapp.config.storage.AbstractWxMaConfigStorageConfiguration;
import com.binarywang.spring.starter.wxjava.miniapp.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.miniapp.properties.WxMaProperties;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

@Configuration
@ConditionalOnProperty(prefix="wx.miniapp.config-storage", name={"type"}, havingValue="jedis")
@ConditionalOnClass(value={JedisPool.class, JedisPoolConfig.class})
public class WxMaInJedisConfigStorageConfiguration
extends AbstractWxMaConfigStorageConfiguration {
    private final WxMaProperties properties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxMaConfig.class})
    public WxMaConfig wxMaConfig() {
        WxMaRedisBetterConfigImpl config = this.getWxMaRedisBetterConfigImpl();
        return this.config((WxMaDefaultConfigImpl)config, this.properties);
    }

    private WxMaRedisBetterConfigImpl getWxMaRedisBetterConfigImpl() {
        RedisProperties redisProperties = this.properties.getConfigStorage().getRedis();
        JedisPool jedisPool = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getJedisPool() : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        JedisWxRedisOps redisOps = new JedisWxRedisOps((Pool)jedisPool);
        return new WxMaRedisBetterConfigImpl((WxRedisOps)redisOps, this.properties.getConfigStorage().getKeyPrefix());
    }

    private JedisPool getJedisPool() {
        WxMaProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxMaInJedisConfigStorageConfiguration(WxMaProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

