/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.ResourceBundle;
import org.metricssampler.cmd.CheckCommand;
import org.metricssampler.cmd.CheckConfigCommand;
import org.metricssampler.cmd.HelpCommand;
import org.metricssampler.cmd.MetadataCommand;
import org.metricssampler.cmd.MetricsCommand;
import org.metricssampler.cmd.SamplerCommand;
import org.metricssampler.cmd.StartCommand;
import org.metricssampler.cmd.StatusCommand;
import org.metricssampler.cmd.StopCommand;
import org.metricssampler.cmd.TestCommand;

public class MetricsSampler {
    public static void main(String[] args) {
        ResourceBundle bundle = ResourceBundle.getBundle("help");
        JCommander commander = MetricsSampler.createCommander(bundle);
        HelpCommand help = MetricsSampler.addCommands(bundle, commander);
        try {
            commander.parse(args);
        }
        catch (ParameterException e) {
            help.error(e);
        }
        if (commander.getParsedCommand() != null) {
            JCommander parsedCommander = (JCommander)commander.getCommands().get(commander.getParsedCommand());
            Runnable cmd = (Runnable)parsedCommander.getObjects().get(0);
            cmd.run();
        } else {
            help.error("help.missingCommand");
        }
    }

    protected static JCommander createCommander(ResourceBundle bundle) {
        JCommander result = new JCommander();
        result.setAcceptUnknownOptions(false);
        result.setCaseSensitiveOptions(false);
        result.setProgramName("metrics-sampler");
        result.setColumnSize(120);
        result.setDescriptionsBundle(bundle);
        return result;
    }

    protected static HelpCommand addCommands(ResourceBundle bundle, JCommander commander) {
        HelpCommand result = new HelpCommand(commander, bundle);
        commander.addCommand((Object)result);
        commander.addCommand((Object)new StartCommand());
        commander.addCommand((Object)new StopCommand());
        commander.addCommand((Object)new StatusCommand());
        commander.addCommand((Object)new SamplerCommand());
        commander.addCommand((Object)new MetadataCommand());
        commander.addCommand((Object)new CheckCommand());
        commander.addCommand((Object)new TestCommand());
        commander.addCommand((Object)new MetricsCommand());
        commander.addCommand((Object)new CheckConfigCommand());
        MetricsSampler.fixResourceBundleBug(commander, bundle);
        return result;
    }

    protected static void fixResourceBundleBug(JCommander jc, ResourceBundle bundle) {
        for (Map.Entry entry : jc.getCommands().entrySet()) {
            JCommander subJc = (JCommander)entry.getValue();
            subJc.setDescriptionsBundle(bundle);
            subJc.setAcceptUnknownOptions(false);
            subJc.setColumnSize(jc.getColumnSize());
            try {
                Method method = subJc.getClass().getDeclaredMethod("createDescriptions", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)subJc, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        }
    }
}

