/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.cmd;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import org.metricssampler.cmd.AbstractCommand;
import org.metricssampler.service.Bootstrapper;
import org.slf4j.LoggerFactory;

public abstract class BootstrappedCommand
extends AbstractCommand {
    protected Bootstrapper bootstrapper;

    @Override
    public void run() {
        this.initLogging();
        try {
            this.bootstrapper = this.createBootstrapper();
        }
        catch (Exception e) {
            System.err.println("Exception raised during bootstrapping. Check out the logs for more information. Message: " + e.getMessage());
            e.printStackTrace();
            System.exit(3);
        }
        this.runBootstrapped();
    }

    protected void initLogging() {
        File userOverrideFile = new File(this.logbackConfig);
        if (userOverrideFile.exists()) {
            this.configureLogback(userOverrideFile);
        } else {
            File defaultFile = new File(this.logbackConfig.replaceAll("\\.xml$", ".default.xml"));
            if (!defaultFile.exists()) {
                System.err.println("Default logback configuration file \"" + defaultFile.getAbsolutePath() + "\" does not exist. Check your installation.");
            }
            this.configureLogback(defaultFile);
        }
    }

    protected void configureLogback(File file) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)context);
        context.reset();
        try {
            jc.doConfigure(file);
        }
        catch (JoranException e) {
            e.printStackTrace();
        }
    }

    protected abstract Bootstrapper createBootstrapper();

    protected abstract void runBootstrapped();
}

