/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.cmd;

import com.beust.jcommander.Parameters;
import org.metricssampler.cmd.SamplersCommand;
import org.metricssampler.reader.MetricReadException;
import org.metricssampler.sampler.Sampler;

@Parameters(commandNames={"check"}, commandDescriptionKey="help.check.command")
public class CheckCommand
extends SamplersCommand {
    private boolean allValid;

    @Override
    protected void preProcess() {
        this.allValid = true;
    }

    @Override
    protected void process(Sampler sampler) {
        this.logger.info("Checking {}", (Object)sampler);
        try {
            boolean valid = sampler.check();
            this.allValid = this.allValid && valid;
        }
        catch (MetricReadException e) {
            this.logger.warn("Sampler threw exception during check", (Throwable)e);
            this.allValid = false;
        }
    }

    @Override
    protected void postProcess() {
        if (this.allValid) {
            this.logger.info("Everything looks alright");
        } else {
            this.logger.info("There were problems. See the logs.");
        }
    }
}

