/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ResourceBundle;
import org.metricssampler.cmd.AbstractCommand;

@Parameters(commandNames={"help"}, commandDescriptionKey="help.help.command")
public class HelpCommand
extends AbstractCommand {
    private final JCommander commander;
    private final ResourceBundle bundle;
    @Parameter(names={"-c"}, descriptionKey="help.param.command")
    private String command;

    public HelpCommand(JCommander commander, ResourceBundle bundle) {
        this.commander = commander;
        this.bundle = bundle;
    }

    @Override
    public void run() {
        this.usage(null, false);
    }

    public void error(String key) {
        this.usage(this.bundle.getString(key), true);
        System.exit(1);
    }

    public void usage(String msg, boolean error) {
        String cmd;
        System.out.println("metrics-sampler ver. " + this.bundle.getString("help.version"));
        if (msg != null) {
            if (error) {
                System.err.println(msg);
            } else {
                System.out.println(msg);
            }
        }
        String string = this.command != null ? this.command : (cmd = error ? this.commander.getParsedCommand() : null);
        if (cmd != null) {
            this.commander.usage(cmd);
        } else {
            this.commander.usage();
        }
        System.exit(0);
    }

    public void error(ParameterException e) {
        this.usage(e.getMessage(), true);
        System.exit(1);
    }
}

