/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.metricssampler.cmd.ConfigurationCommand;
import org.metricssampler.config.InputConfig;
import org.metricssampler.reader.MetricName;
import org.metricssampler.reader.MetricsReader;
import org.metricssampler.resources.SamplerStats;
import org.metricssampler.service.Bootstrapper;

@Parameters(commandNames={"metadata"}, commandDescriptionKey="help.metadata.command")
public class MetadataCommand
extends ConfigurationCommand {
    @Parameter(names={"-n"}, descriptionKey="help.param.inputs")
    protected List<String> inputs = new LinkedList<String>();

    @Override
    protected void runBootstrapped() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.inputs);
        Bootstrapper factory = this.bootstrapper;
        for (InputConfig input : this.bootstrapper.getConfiguration().getInputs()) {
            SamplerStats.init();
            if (!names.isEmpty() && !names.contains(input.getName())) continue;
            MetricsReader reader = factory.newReaderForInput(input);
            reader.open();
            System.out.println("Reader: " + input.getName());
            for (MetricName item : reader.readNames()) {
                System.out.println("\tName:" + item.getName());
                System.out.println("\tDescription:" + item.getDescription());
            }
            reader.close();
            SamplerStats.unset();
        }
    }
}

