/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import org.metricssampler.cmd.ControlCommand;

@Parameters(commandNames={"resource"}, commandDescriptionKey="help.resource.command")
public class ResourceCommand
extends ControlCommand {
    @Parameter(names={"-n"}, descriptionKey="help.param.resource.names", required=true)
    protected List<String> resources = new LinkedList<String>();
    @Parameter(names={"-a"}, descriptionKey="help.param.resource.action", required=true)
    protected String action;

    @Override
    protected void runBootstrapped() {
        for (String resource : this.resources) {
            String prefix = this.action + " resource \"" + resource + "\": ";
            try {
                String response = this.execute(this.bootstrapper.getControlHost(), this.bootstrapper.getControlPort(), "resource " + resource + " " + this.action);
                System.out.println(prefix + response);
            }
            catch (UnknownHostException e) {
                System.err.println(prefix + e.getMessage());
            }
            catch (IOException e) {
                System.err.println(prefix + e.getMessage());
            }
        }
    }
}

